# AdaptSim
AdaptSim: Task-Driven Simulation Adaptation for Sim-to-Real Transfer

## Installation

Install the conda environment with dependencies (tested with Ubuntu 20.04):
```console
conda env create -f environment_linux.yml
pip install -e .
```

AdaptSim is based on Drake, a physically-realistic simulator suited for contact-rich manipulation tasks.

```console
export PYTHONPATH=${PWD}/install/lib/python3.8/site-packages:${PYTHONPATH}
```

SNOPT solver is ideal for solving inverse kinematics in Drake.

```bash
cmake -DWITH_SNOPT=ON -DSNOPT_PATH={SNOPT_PATH} ../drake
```

## Usage

Test the double pendulum, pushing, and scooping environment.
```bash
python test/test_double_pendulum_linearized.py
python test/test_push.py --gui
python test/test_scoop.py --gui
```

We also provide other environments including `AcrobotEnv`, 'PendulumEnv`, and `DoublePendulumEnv` that are not used in the paper.

Open Drake Visualizer / Meldis for visualization (especially the contacts).
```bash
cd ~/drake && bazel run //tools:drake_visualizer
cd ~/drake && bazel run //tools:meldis
```

Training the adaptation policies in simulation.
```bash
python script/run_adapt.py -cf cfg/pretrain_dp.yaml
python script/run_adapt_trainer.py -cf cfg/pretrain_push.yaml
python script/run_adapt_trainer.py -cf cfg/pretrain_scoop.yaml
```
