#!/bin/bash

# ----- Make sure to export nnUNet_preprocessed and nnUNet_results before running this -----

# Lists of parameters to loop through
FOLDS=(0 1 2 3 4)
CPR_KAPPA_INIT_STEPS=(1000 2000 3000 4000)
# Dataset IDs following nnUNet: 2=Dataset002_Heart, 17=Dataset017_AbdominalOrganSegmentation, 82=Dataset082_BraTS2020
# If you give them other IDs in the nnUNet preprocessing, you need to change them here as well
DATASETS=(2 17 82)

# Base command without the parameters to be looped
BASE_CMD="python train_nnUNet.py"

# Nested loops for each parameter setting
for FOLD in "${FOLDS[@]}"
do
    for DATASET_NR in "${DATASETS[@]}"
    do
        for KAPPA_INIT_STEPS in "${CPR_KAPPA_INIT_STEPS[@]}"
        do
            # Construct the full command with current parameter values
            FULL_CMD="${BASE_CMD} ${DATASET_NR} 3d_fullres ${FOLD} -tr nnUNetTrainerQuickAdamCPR -adam_cpr_mode l2_constrain_mh -adam_cpr_kappa 1.0 -adam_cpr_kappa_init_steps ${KAPPA_INIT_STEPS}"
            
            echo $FULL_CMD
        done
    done
done
