#pragma once
#include <vector>
#include <string>
#include <fstream>
#include <iostream>
#include <algorithm>
#include <filesystem>
#include "event.h"

template <class LABEL_T>
class Dataset {
    public :
        virtual std::vector<std::vector<Event> > get_binned_input(int id) = 0;
        virtual LABEL_T get_label(int id) = 0;
        virtual int size() = 0;
};

class NMNIST : public Dataset<int> {
    public :
        std::string dataset_root;
        std::vector<std::pair<std::string, int> > path_label;
        int time_window;
        bool include_incomplete;

        static std::vector<std::vector<Event> > read_nmnist_event(const std::string &filePath, int time_window=30000, bool include_incomplete=false);

        NMNIST(const std::string &dataset_root, int time_window=30000, bool include_incomplete=false);
        std::vector<std::vector<Event> > get_binned_input(int id);
        int get_label(int id);
        int size();
};


class DVSGesture : public Dataset<int> {
    public :
        std::string dataset_root;
        std::vector<std::string> id_path;
        std::vector<int> id_label;
        int time_window;
        bool include_incomplete;

        static std::vector<std::vector<Event> > read_dvsgesture_event(std::string filePath, int time_window=30000, bool include_incomplete=false);

        DVSGesture(std::string dataset_root, int time_window=30000, bool include_incomplete=false);
        std::vector<std::vector<Event> > get_binned_input(int id);
        int get_label(int id);
        int size();
};

// class DVS_CIFAR10 : public Dataset<int> {
//     public :
//         std::string dataset_root;
//         std::vector<std::pair<std::string, int> > path_label;
//         int time_window;
//         bool include_incomplete;

//         static std::vector<std::vector<Event> > read_dvscifar10_event(const std::string &filePath, int time_window=30000, bool include_incomplete=false);

//         DVS_CIFAR10(const std::string &dataset_root, int time_window=30000, bool include_incomplete=false);
//         std::vector<std::vector<Event> > get_binned_input(int id);
//         int get_label(int id);
//         int size();
// };

class CIFAR10DVS : public Dataset<int> {
    public :
        std::string dataset_root;
        std::vector<std::pair<std::string, int> > path_label;
        int time_window;
        bool include_incomplete;

        static std::vector<std::vector<Event> > read_cifar10dvs_event(const std::string &filePath, int time_window=30000, bool include_incomplete=false);

        CIFAR10DVS(const std::string &dataset_root, int time_window=30000, bool include_incomplete=false);
        std::vector<std::vector<Event> > get_binned_input(int id);
        int get_label(int id);
        int size();
};