#pragma once
#include "dataset.h"
#include "utils.h"
#include "nn.h"
#include <future>
#include <functional>

template <class LABEL_T>
class DistributedDatasetWrapper : public Dataset<LABEL_T> {
    public :
        Dataset<LABEL_T> * ds;
        int world_size, rank, local_size;

        DistributedDatasetWrapper(Dataset<LABEL_T> * ds, int world_size, int rank);

        int get_label(int id);
        std::vector<std::vector<Event> > get_binned_input(int id);
        int size();
};

class DistributedModel {
    public :
        std::vector<Model > model_list;
        int world_size;
        DistributedModel() {}
        DistributedModel(Model model_org, int world_size);
};

class DistributedReadOut {
    public :
        std::vector<ReadOut* > readout_list;
        int world_size;
        DistributedReadOut() {}
        DistributedReadOut(ReadOut * readout_org, int world_size);
};

double test_distributed(DistributedModel & net, Dataset<int> * ds, DistributedReadOut & readout_func, bool verbose=false, bool binned=true);