#pragma once
#include <cstdio>
#include <vector>
#include <map>
#include <random>
#include <fstream>

class Event {
    // Channel id, x pos, y pos, time stamp, amplitude (spike num)
    public : int c, x, y, ts, A;
    Event();
    Event(int x, int ts, int A=1);
    Event(int c, int x, int y, int ts, int A=1);
    bool operator < (const Event &e) const;
    void print();
};

double randn();
double randn(double mean, double stddev);
double randu();
double randu(double L, double R);
std::vector<Event> unbin_events(const std::vector<std::vector<Event> > &vec);
int event_argmax1d(const std::vector<Event> &vec);
