#pragma once
#include <vector>
#include <cassert>
#include <cstring>
#include "event.h"
#include "nn.h"
#include "dataset.h" 

// Time related
long long cross_sys_clock_ms();
long long cross_sys_clock_us();
long long cross_sys_clock_ns();

// Visualization
void visualize_2d(const std::vector<std::vector<Event> > &x, int out_H, int out_W, int t_min, int t_max, int mode, int threshold);

// Network related
std::vector<Event> run_net(std::vector<Module*> & net, std::vector<Event> x);
std::vector<std::vector<Event> > run_net(std::vector<Module*> & net, std::vector<std::vector<Event> > binned_x);
double test(std::vector<Module*> & net, Dataset<int> * ds, ReadOut * readout_layer, bool verbose=false, bool binned=true);
