#include "event.h"
// #define DEBUG

Event::Event() : c(0), x(0), y(0), ts(0), A(0) {}
Event::Event(int x, int ts, int A) : c(0), x(x), y(0), ts(ts), A(A) {}
Event::Event(int c, int x, int y, int ts, int A) : c(c), x(x), y(y), ts(ts), A(A) {}
bool Event::operator < (const Event &e) const {
    return ts < e.ts;
}

std::random_device rd;
std::mt19937 gen(rd());
std::normal_distribution<double> N_distribution(0, 1);
std::uniform_real_distribution<double> U_distribution(0.0, 1.0);
double randn() {
    return N_distribution(gen);
}

double randn(double mean, double stddev) {
    return N_distribution(gen) * stddev + mean;
}

double randu() {
    return U_distribution(gen);
}

double randu(double L, double R) {
    return U_distribution(gen) * (R - L) + L;
}

std::vector<Event> unbin_events(const std::vector<std::vector<Event> > &vec) {
    std::vector<Event> ret;
    for (auto v : vec) {
        for (auto e : v)
            ret.push_back(e);
    }
    return ret;
}

int event_argmax1d(const std::vector<Event> &vec) {
    std::map<int, int > pos_cnt;
    for (const auto &e : vec) ++pos_cnt[e.x];

    // static std::ofstream outf("dvs_gesture_snn_simulator.txt");
    // for (int i = 0; i < 11; ++i)
    //     outf << pos_cnt[i] << " ";
    // outf << "\n";

    int mx = 0, mx_class = 0;
    for (const auto &e : pos_cnt) {
        if (e.second > mx)
            mx_class = e.first, mx = e.second;
    }

    return mx_class;
}

#ifdef DEBUG
int main() {
    Event A;
    ConvEvent B;
    A = B;
    return 0;
}

#endif