#include "tensor.h"

void alloc_tensor_4d(float_T **** & w, int a, int b, int c, int d, float_T init_value) {
	w = (float_T ****) malloc (a * sizeof(float_T ***));
	for (int i = 0; i < a; ++i) {
		w[i] = (float_T ***) malloc (b * sizeof(float_T **));
		for (int j = 0; j < b; ++j) {
			w[i][j] = (float_T **) malloc (c * sizeof(float_T *));
			for (int k = 0; k < c; ++k) {
				w[i][j][k] = (float_T *) malloc (d * sizeof(float_T));
				for (int l = 0; l < d; ++l) {
					w[i][j][k][l] = init_value;
				}
			}
		}
	}
}

void alloc_tensor_3d(float_T *** & w, int a, int b, int c, float_T init_value) {
    w = (float_T ***) malloc (a * sizeof(float_T **));
    for (int i = 0; i < a; ++i) {
        w[i] = (float_T **) malloc (b * sizeof(float_T *));
        for (int j = 0; j < b; ++j) {
            w[i][j]= (float_T *) malloc (c * sizeof(float_T));
            for (int k = 0; k < c; ++k) {
                w[i][j][k] = init_value;
            }
        }
    }
}

void clone_tensor_4d(float_T **** & w, int a, int b, int c, int d, float_T **** & value) {
	for (int i = 0; i < a; ++i) {
		for (int j = 0; j < b; ++j) {
			for (int k = 0; k < c; ++k) {
				for (int l = 0; l < d; ++l) {
					w[i][j][k][l] = value[i][j][k][l];
				}
			}
		}
	}
}

void clone_tensor_3d(float_T *** & w, int a, int b, int c, float_T *** & value) {
	for (int i = 0; i < a; ++i) {
		for (int j = 0; j < b; ++j) {
			for (int k = 0; k < c; ++k) {
				w[i][j][k] = value[i][j][k];
			}
		}
	}
}

void free_tensor_4d(float_T **** & w, int a, int b, int c, int d) {
	if (*w == NULL) return;
	for (int i = 0; i < a; ++i) {
		for (int j = 0; j < b; ++j) {
			for (int k = 0; k < c; ++k) {
				free(w[i][j][k]);
			}
			free(w[i][j]);
		}
		free(w[i]);
	}
	free(w);
	w = NULL;
}

void free_tensor_3d(float_T *** & w, int a, int b, int c) {
	if (*w == NULL) return;
	for (int i = 0; i < a; ++i) {
		for (int j = 0; j < b; ++j) {
			free(w[i][j]);
		}
		free(w[i]);
	}
	free(w);
	w = NULL;
}