import openai
from requests.packages.urllib3.util.retry import Retry
from requests.adapters import HTTPAdapter
import requests
import json

openai_api = ""
print("OPENAI_API_ADDR:" + openai_api)
model = "gpt-4-1106-preview"

class OpenAIApiException(Exception):
    def __init__(self, msg, error_code):
        self.msg = msg
        self.error_code = error_code


class OpenAIApiProxy():
    def __init__(self, api_key=""):
        retry_strategy = Retry(
            total=50,  # 最大重试次数（包括首次请求）
            backoff_factor=1,  # 重试之间的等待时间因子
            status_forcelist=[429, 500, 502, 503, 504, 404],  # 需要重试的状态码列表
            allowed_methods=["POST"]  # 只对POST请求进行重试
        )
        adapter = HTTPAdapter(max_retries=retry_strategy)
        # 创建会话并添加重试逻辑
        self.session = requests.Session()
        self.session.mount("https://", adapter)
        self.session.mount("http://", adapter)
        self.api_key = api_key

    def call(self, model_name, prompt, headers={}, max_tokens=512):
        params_gpt = {
            "model": model_name,
            "messages": [{"role": "user", "content":''}],
            # "max_tokens": max_tokens,
            # "stop": "\n" if max_tokens <= 10 else None,
            "temperature": 0,
        }
        params_gpt['model'] = model_name
        params_gpt['messages'][0]['content'] = prompt
        # print(len(prompt))

        headers['Content-Type'] = headers['Content-Type'] if 'Content-Type' in headers else 'application/json'
        if self.api_key:
            headers['Authorization'] = "Bearer " + self.api_key
        url = openai_api + '/v1/chat/completions'
        # print(url)
        # print(json.dumps(params_gpt, indent=4))
        response = self.session.post(url, headers=headers, data=json.dumps(params_gpt))

        if response.status_code != 200:
            err_msg = "access openai error, status code: %s" % (response.status_code)
            raise OpenAIApiException(err_msg, response.status_code)
        # print(response)
        data = json.loads(response.text)
        return data
    
if __name__ == "__main__":
    proxy = OpenAIApiProxy()
    test_prompt = "你好，你是谁"
    resp = proxy.call(model, test_prompt)
    print(resp)
    print(resp["choices"][0]["message"]["content"].split('\n')[0].strip())
