import json
from utils import read_jsonl, save_jsonl
import pandas as pd
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--json-path", type=str, required=True)
parser.add_argument("--output-path", type=str, required=True)
parser.add_argument("--bon-res", type=bool, default=False)
args = parser.parse_args()

TYPE = 1 # 0：多个答案按多个回答计数 1：多个答案取平均值 

print("-----------------------")
print("Slogan evaluate.")
data = []
read_jsonl(args.json_path, data)

valid_num = 0

score_info = {
    "count" : {
        "汉字": [],
        "英文单词": []
    },
    "content": {
        "汉字": [],
        "英文单词": []
    }
}

perfect_info = {
    "count" : {
        "汉字": 0,
        "英文单词": 0
    },
    "content": {
        "汉字": 0,
        "英文单词": 0
    }
}

raw_header = ["type"]
name_list = ["整体", "汉字", "英文单词"]
reward_type = ["count", "content"]
cal_type = ["均分", "满分比例"]
for n in name_list:
    for score_type in reward_type:
        for c_type in cal_type:
            raw_header.append(n + score_type + c_type)
out_df = pd.DataFrame(columns=raw_header)

for TYPE in [0, 1]:
    for d in data:
        if d["rewards"]["content"][0] != 0 and len(d["rewards"]["count"]) == len(d["rewards"]["content"]):
            valid_num += 1
            if TYPE == 0:
                for score_type in score_info.keys():
                    for score in d["rewards"][score_type]:
                        score_info[score_type][d["tags"]["粒度"]].append(score)
                        if (score_type == "count" and score == 1.0) or (score_type == "content" and score == 4.0):
                            perfect_info[score_type][d["tags"]["粒度"]] += 1
            elif TYPE == 1:
                for score_type in score_info.keys():
                    score = sum(d["rewards"][score_type])/len(d["rewards"][score_type])
                    score_info[score_type][d["tags"]["粒度"]].append(score)
                    if (score_type == "count" and score == 1.0) or (score_type == "content" and score == 4.0):
                        perfect_info[score_type][d["tags"]["粒度"]] += 1
    one_data = {}
    one_data["type"] = TYPE
    for n in name_list:
        for score_type in reward_type:
            for c_type in cal_type:
                cur_name = n + score_type + c_type
                if n == "整体":
                    if c_type == "均分":
                        one_data[cur_name] = round(1.0 * (sum(score_info[score_type]["汉字"])+sum(score_info[score_type]["英文单词"]))/(len(score_info[score_type]["汉字"])+len(score_info[score_type]["英文单词"])), 4)
                    else:
                        one_data[cur_name] = round(1.0 * float(perfect_info[score_type]["汉字"]+perfect_info[score_type]["英文单词"])/(len(score_info[score_type]["汉字"])+len(score_info[score_type]["英文单词"])), 4)
                else:
                    if c_type == "均分":
                        one_data[cur_name] = round(1.0 * sum(score_info[score_type][n])/len(score_info[score_type][n]), 4)
                    else:
                        one_data[cur_name] = round(1.0 * float(perfect_info[score_type][n])/len(score_info[score_type][n]), 4)
    out_df = pd.concat([out_df, pd.DataFrame(one_data, index=[0])], axis=0, ignore_index=True)
out_df.to_excel(args.output_path, index=False)

# print("测试文件：", INPUT)      
# print("有效且保留的回答个数：", valid_num)
# print("TYPE：", TYPE)
# for score_type in score_info.keys():
#     print("整体", score_type, "均分：", (sum(score_info[score_type]["汉字"])+sum(score_info[score_type]["英文单词"]))/(len(score_info[score_type]["汉字"])+len(score_info[score_type]["英文单词"])))
#     print("整体", score_type, "满分比例：", float(perfect_info[score_type]["汉字"]+perfect_info[score_type]["英文单词"])/(len(score_info[score_type]["汉字"])+len(score_info[score_type]["英文单词"])))
#     for lidu_type in score_info[score_type].keys():
#         print(lidu_type, score_type, "均分：", sum(score_info[score_type][lidu_type])/len(score_info[score_type][lidu_type]))
#         print(lidu_type, score_type, "满分比例：", float(perfect_info[score_type][lidu_type])/len(score_info[score_type][lidu_type]))
