import json
import re
from utils import read_jsonl, save_jsonl
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--json-path", type=str, required=True)
parser.add_argument("--output-path", type=str, required=True)
args = parser.parse_args()

if __name__ == '__main__':
    print("-----------------------")
    print("Slogan post reward process.")
    data = []
    read_jsonl(args.json_path, data)

    new_data = []
    error_count = 0
    for d in data:
        try:
            d["rewards"]["content"] = [float(item) for item in d["rewards"]["content"][1:-1].split(',')]
            new_data.append(d)
        except:
            error_count += 1
    print("error count", error_count)
    print("left data", len(new_data))

    save_jsonl(new_data, args.output_path)