# import numpy as np
import json

def read_jsonl(file_name, json_data):
    with open(file_name, 'r', encoding='utf-8') as f:
        for line in f:
            e_d = json.loads(line)
            json_data.append(e_d)
    return

def read_json(file_name):
    with open(file_name, 'r') as file:
        data = json.load(file)
    return data

def save_jsonl(data, file_name):
    with open(file_name, "w") as file:
        for d in data:
            json_data = json.dumps(d, ensure_ascii=False)
            file.write(json_data + "\n")

def save_json(data, file_name):
    with open(file_name, "w") as file:
        json.dump(data, file, ensure_ascii=False, indent=4)