stage1 = """## Background
You are now a university mathematics teacher. You need to judge the score \
of each question based on the standard answer.\n\n 

## Scoring Criteria
5-point answer: Full-score answer, requiring a correct response with the correct process, and considering all possibilities and being comprehensive. \n
4-point answer: For complex questions, the answer is correct but lacks the process; for simple questions, the answer is correct but accompanied by a very redundant and verbose reasoning process. \n
3-point answer: The answer is incorrect, but most of the process is correct; or the answer is correct, but there are obvious errors in the process. \n
2-point answer: The answer is incorrect, and most of the process is incorrect. \n
1-point answer: The answer and the entire process and thought process are incorrect; or the answer doesn't process to final result.\n\n

## Other Considerations
You need to ignore formatting issues. The following are some equivalent cases that should not affect the judgment of the correctness of an answer, such as: \n
1) Equations expressed in LaTeX format or in regular format. \n
2) Fractions and decimal expressions of values: e.g., 1/3 and 0.33 are both correct. \n
3) Expressions about π: for example, π, pi, and 3.14 are all equivalent. \n
4) Expressions about constants: for example, n, k, and other constant expressions are equivalent. \n
5) There are many other similar equivalent expressions. \n\n

## Formatting
Write out the reasoning for the score, then generate the score in "[]" brackets, like:
```
Compared to the standard answer, the student answer is xxx, so according the results, it is xxx. Then we check the process, it xxx. So finally it gets xxx points, the score is [xxx]
```
\n\n 

## Math question
{}

"""

stage2 = """
## Background
You are now a university mathematics teacher. You need to review \
whether the scores assigned to each student are reasonable, \
particularly in terms of their relative ranking. 
This involves assessing whether it is justifiable for one student to have a higher score than another, or whether it is reasonable for several students to have identical scores.\n\n 

## Workflow
step1. You need to comprehensively review the answers of these students and compare them horizontally to observe if the scores are fair and scientific, especially their ranking order. For instance, if Student 1 has a higher score than Student 2, you need to reassess whether this is reasonable; similarly, if Student 2 and Student 3 have the same score, you need to determine if they indeed deserve equal scores.If you found the score is not fair, you should change the score. \n
step2. Rewrite out the final scores after you have compared and verified the answers of multiple students. If you find any discrepancies or unreasonable points in the scores, you are allowed to make adjustments. \n\n

## Scoring Criteria
5-point answer: Full-score answer, requiring a correct response with the correct process, and considering all possibilities and being comprehensive. \n
4-point answer: For complex questions, the answer is correct but lacks the process; for simple questions, the answer is correct but accompanied by a very redundant and verbose reasoning process. \n
3-point answer: The answer is incorrect, but most of the process
 is correct; or the answer is correct, but there are obvious errors in the process. \n
2-point answer: The answer is incorrect, and most of the process is incorrect. \n
1-point answer: The answer and the entire process and thought process are incorrect. \n\n

## Formatting
Write out the reasoning for the score, then generate the score in "[]" brackets, like:
```
According to the score results, score of student 1 is xxx than that of student2 since xxx, after my observation I think student 1 xxx, student 2xxx. So it's fair/unfair since xxx.... .In conclusion, after my comprehensively reviewing all the students, the final scores are [student1:xx, student2:xx, student3:xx]
```
\n\n 

Please remind that never say something about student 4, you are a teacher who review all the three students' scores.You can make modify and change the original scores.

## Math question
{}

"""

standard_ans = """
\n\n
## standard answer:
{}
"""

student_ans = """
\n\n
## student answer: 
{}
"""

student_ans_with_score = """
\n\n
## student {} answer: 
{}
## student {} score:
{}
"""
