import json
import sys
import matplotlib.pyplot as plt
import tqdm

def plot(infile,outfile,dataset_type):
    json_data = infile
    json_data_list = [json.loads(line.strip(), strict=False) for line in open(json_data)]

    score_list = [0] * 5

    for index, value in enumerate(json_data_list):
        if value['stage_1_score'] == "1":
            score_list[0] +=1
        if value['stage_1_score'] == "2":
            score_list[1] +=1
        if value['stage_1_score'] == "3":
            score_list[2] +=1
        if value['stage_1_score'] == "4":
            score_list[3] +=1
        if value['stage_1_score'] == "5":
            score_list[4] +=1

    print(score_list)


    labels = ['1', '2', '3', '4', '5']
    sizes = [100 * score_list[i]/1072 for i in range(len(score_list))]

    # 创建饼状图
    plt.pie(sizes, labels=labels, autopct='%1.1f%%')

    # 添加标题
    plt.title(dataset_type)

    # 显示图形
    plt.show()

    # 将图形保存为文件
    plt.savefig(outfile)

if __name__ == "__main__":
    in_file = sys.argv[1]
    out_file = sys.argv[2]
    dataset_type = sys.argv[3]
    plot(in_file,out_file,dataset_type)
