import pandas as pd
import sklearn as sk
import sys
import warnings

from evaluation import classifier_evaluation, regressor_evaluation, classifier_evaluation_with_model, regressor_evaluation_with_model

# Increase recursion limit
sys.setrecursionlimit(10**6)

# Ignore warnings
warnings.filterwarnings("ignore")

# Example usage

# data = pd.read_csv('diabetes.csv')
# X = data.drop('Outcome', axis=1)  # Input features
# Y = data['Outcome']  # Target variable

data = pd.read_csv('wine.data', delimiter=',', header=None)
data.columns = ['class', 'alcohol', 'malic_acid', 'ash', 'alcalinity_of_ash', 'magnesium', 'total_phenols', 'flavanoids', 'nonflavanoid_phenols', 'proanthocyanins', 'color_intensity', 'hue', 'od280/od315_of_diluted_wines', 'proline']
X = data.drop('class', axis=1)  # Input features
Y = data['class']  # Target variable

classifier = sk.tree.DecisionTreeClassifier()
print('Decision Tree Classifier')
classifier_evaluation_with_model(classifier, X, Y)
print("#"*30)

classifier = sk.ensemble.RandomForestClassifier()
print('Random Forest Classifier')
classifier_evaluation_with_model(classifier, X, Y)
print("#"*30)

classifier = sk.linear_model.LogisticRegression()
print('Logistic Regression Classifier')
classifier_evaluation_with_model(classifier, X, Y)
print("#"*30)

# data = pd.read_csv('auto-mpg.data', delim_whitespace=True, header=None)
# data = data.replace('?', pd.NA)
# data.dropna(inplace=True)
# data.columns = ['mpg', 'cylinders', 'displacement', 'horsepower', 'weight', 'acceleration', 'model_year', 'origin', 'car_name']
# data = data.drop('car_name', axis=1)

# X = data.drop('mpg', axis=1)  # Input features
# Y = data['mpg']  # Target variable
# X['horsepower'] = X['horsepower'].astype(float)

data = pd.read_excel('Concrete_Data.xls')
X = data.drop('Concrete compressive strength(MPa, megapascals) ', axis=1)  # Input features
Y = data['Concrete compressive strength(MPa, megapascals) ']  # Target variable

regressor = sk.tree.DecisionTreeRegressor()
print('Decision Tree Regressor')
regressor_evaluation_with_model(regressor, X, Y)
print("#"*30)

regressor = sk.ensemble.RandomForestRegressor()
print('Random Forest Regressor')
regressor_evaluation_with_model(regressor, X, Y)
print("#"*30)

regressor = sk.linear_model.LinearRegression()
print('Linear Regression Regressor')
regressor_evaluation_with_model(regressor, X, Y)
