import pandas as pd
import sklearn as sk
import sys
import warnings
import time

from evaluation import classifier_evaluation, regressor_evaluation, classifier_evaluation_with_model, regressor_evaluation_with_model
from method import *
# Increase recursion limit
sys.setrecursionlimit(10**6)

# Ignore warnings
warnings.filterwarnings("ignore")

# Example usage

num_instances = 100

# for num_features in [3,4,5,6,7,8,9,10,11]:

#     print('Number of features:', num_features)
#     print('Number of instances:', num_instances)

#     data = np.random.rand(num_instances, num_features+1)

#     X = pd.DataFrame(data[:, :-1])  # Input features
#     Y = pd.Series(data[:, -1])  # Target variable

#     start = time.time()
#     sobol_total = sobol_total_indices(X, Y)
#     end = time.time()
#     print('Time taken for sobol_total_indices:', end-start)

#     start = time.time()
#     shap_values = calculate_shapley_values(X, Y)
#     end = time.time()
#     print('Time taken for calculate_shapley_values:', end-start)

num_features = 5

for num_instances in [50,100,150,200,250,300,350,400]:

    print('Number of features:', num_features)
    print('Number of instances:', num_instances)

    data = np.random.rand(num_instances, num_features+1)

    X = pd.DataFrame(data[:, :-1])  # Input features
    Y = pd.Series(data[:, -1])  # Target variable

    start = time.time()
    sobol_total = sobol_total_indices(X, Y)
    end = time.time()
    print('Time taken for sobol_total_indices:', end-start)

    start = time.time()
    shap_values = calculate_shapley_values(X, Y)
    end = time.time()
    print('Time taken for calculate_shapley_values:', end-start)