import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns


# Data
num_features = [3, 4, 5, 6, 7, 8]
sobol_times = [0.035, 0.043, 0.054, 0.065, 0.074, 0.085]  # Sobol's total indices times in seconds
shapley_times = [0.394, 2.306, 15.492, 114.161, 964.787, 9111.088]  # Shapley values times in seconds

# Plot
plt.figure(figsize=(10, 6))
plt.plot(num_features, sobol_times, marker='o', color='red', label="Sobol's total indices")
plt.plot(num_features, shapley_times, marker='o', color='blue', label="Shapley values")
plt.yscale('log')  # Log scale for y-axis (runtime)
plt.xlabel('Number of Features',fontsize=24)
plt.ylabel('Runtime (seconds)',fontsize=24)
# plt.title('Runtime Comparison of Sobol\'s Total Indices and \n Shapley Values With Instance Number Fixed to 100', fontsize=24)
plt.legend(fontsize=24)
plt.grid(True)
plt.tight_layout()
plt.xticks(fontsize=16)
plt.yticks(fontsize=16)

# Save plot to PDF file
plt.savefig('runtime_comparison1.pdf')

# Show plot (optional)
plt.show()


# Data
num_instances = [50, 100, 150, 200, 250, 300, 350, 400]
sobol_times = [0.030, 0.053, 0.079, 0.106, 0.132, 0.158, 0.185, 0.210]  # Sobol's total indices times in seconds
shapley_times = [7.709, 15.150, 22.816, 30.058, 37.519, 45.247, 52.752, 60.134]  # Shapley values times in seconds

# Plot
plt.figure(figsize=(10, 6))
plt.plot(num_instances, sobol_times, marker='o', color='red', label="Sobol's total indices")
plt.plot(num_instances, shapley_times, marker='o', color='blue', label="Shapley values")
# plt.yscale('log')  # Log scale for y-axis (runtime)
plt.xlabel('Number of Instances',fontsize=24)
plt.ylabel('Runtime (seconds)',fontsize=24)
# plt.title('Runtime Comparison of Sobol\'s Total Indices and \n Shapley Values With Feature Number Fixed to 5', fontsize=24)
plt.legend(fontsize=24)
plt.grid(True)
plt.tight_layout()
plt.xticks(fontsize=16)
plt.yticks(fontsize=16)

# Save plot to PDF file
plt.savefig('runtime_comparison2.pdf')

# Show plot
plt.show()



# Data
number_of_features = ['8', '7', '6', '5', '4', '3', '2', '1']
sobol_mean = [0.7734791524265209, 0.7695659603554341, 0.7734449760765549, 0.7552631578947369, 0.7526486671223512, 0.6900546821599453, 0.6562371838687627, 0.6524265208475735]
sobol_std = [0.03803416261652964, 0.03520041689702377, 0.029136696348063953, 0.030001701566434964, 0.03619598169845188, 0.031632995177048796, 0.03408985980085849, 0.040715097010808464]
shapley_mean = [0.7734791524265209, 0.7669514695830486, 0.7514183185235817, 0.6783492822966507, 0.6601845522898155, 0.6537252221462747, 0.6562542720437458, 0.6484791524265208]
shapley_std = [0.03803416261652964, 0.03786832110326253, 0.03899325708578139, 0.033935996936325485, 0.0331192681452069, 0.03222349557472942, 0.02104208753185001, 0.017781894456129457]

# Convert to numpy arrays for easy manipulation
sobol_mean = np.array(sobol_mean)
sobol_std = np.array(sobol_std)
shapley_mean = np.array(shapley_mean)
shapley_std = np.array(shapley_std)

# Prepare the data for boxplot
data_sobol = [np.random.normal(loc=mean, scale=std, size=100) for mean, std in zip(sobol_mean, sobol_std)]
data_shapley = [np.random.normal(loc=mean, scale=std, size=100) for mean, std in zip(shapley_mean, shapley_std)]

# Plot
plt.figure(figsize=(14, 8))

# Boxplot for Sobol's Total Indices
sns.boxplot(data=data_sobol, boxprops=dict(facecolor='none', edgecolor='red', linestyle='--', linewidth=1), 
            whiskerprops=dict(color="red", linestyle='--', linewidth=1.5), capprops=dict(color="red", linestyle='--', linewidth=1.5), 
            medianprops=dict(color="red", linestyle='--', linewidth=2), showfliers=False)
# Connecting mean points for Sobol's Total Indices
plt.plot(sobol_mean, marker='D', markersize=10, color='red', markerfacecolor='red', linestyle='-', linewidth=3, label="Sobol's Total Indices")

# Boxplot for Shapley Values
sns.boxplot(data=data_shapley, boxprops=dict(facecolor='none', edgecolor='blue', linestyle='--', linewidth=1), 
            whiskerprops=dict(color="blue", linestyle='--', linewidth=1.5), capprops=dict(color="blue", linestyle='--', linewidth=1.5), 
            medianprops=dict(color="blue", linestyle='--', linewidth=2), showfliers=False)
# Connecting mean points for Shapley Values
plt.plot(shapley_mean, marker='*', markersize=10, color='blue', markerfacecolor='blue', linestyle='-', linewidth=3, label='Shapley Values')

plt.grid(True, linestyle='--', linewidth=0.7, alpha=0.7)

# Labels and title
plt.xticks(range(len(number_of_features)), number_of_features, fontsize=16)
plt.yticks(fontsize=16)
plt.xlabel('Number of Features Left in The Model', fontsize=24)
plt.ylabel('Classification Accuracy', fontsize=24)
# plt.title('Comparison of Sobol\'s Total Indices and Shapley Values', fontsize=20)
plt.legend(fontsize=24)
plt.tight_layout()

# Save plot to PDF file
plt.savefig('classification.pdf')

# Show plot
plt.show()



# Regression

# Data
num_of_features = ['7', '6', '5', '4', '3', '2', '1']
sobol_mean = [0.764452868817497, 0.7618708063653902, 0.7289752520533799, 0.7031259639701745, 0.5373201606494754, -0.06092303903655073, -0.27588265133109974]
sobol_std = [0.16936652119800655, 0.16347437579659332, 0.18360929804994924, 0.17939513342257005, 0.19145865751521338, 0.3946144227526271, 0.6832328105860065]
shapley_mean = [0.7646748382065442, 0.7579241184018066, 0.43855924865214807, 0.4304014450742891, 0.37889101861480234, 0.39754963182069947, 0.15616734584631328]
shapley_std = [0.16802503083140488, 0.16963785612569016, 0.3891562532872541, 0.3863877287914753, 0.41577969729793224, 0.3998819228318619, 0.5916236418570453]

# Convert to numpy arrays for easy manipulation
sobol_mean = np.array(sobol_mean)
sobol_std = np.array(sobol_std)
shapley_mean = np.array(shapley_mean)
shapley_std = np.array(shapley_std)

# Prepare the data for boxplot
data_sobol = [np.random.normal(loc=mean, scale=std, size=100) for mean, std in zip(sobol_mean, sobol_std)]
data_shapley = [np.random.normal(loc=mean, scale=std, size=100) for mean, std in zip(shapley_mean, shapley_std)]

# Plot
plt.figure(figsize=(14, 8))

# # Boxplot for Sobol's Total Indices
# sns.boxplot(data=data_sobol, boxprops=dict(facecolor='none', edgecolor='blue', linewidth=1.5), 
#             whiskerprops=dict(color="blue", linewidth=1.5), capprops=dict(color="blue", linewidth=1.5), 
#             medianprops=dict(color="blue", linewidth=2), showfliers=False)
# # Connecting mean points for Sobol's Total Indices
# plt.plot(sobol_mean, marker='o', color='blue', linestyle='--', linewidth=2, label="Sobol's Total Indices")
# 
# # Boxplot for Shapley Values
# sns.boxplot(data=data_shapley, boxprops=dict(facecolor='none', edgecolor='red', linewidth=1.5), 
#             whiskerprops=dict(color="red", linewidth=1.5), capprops=dict(color="red", linewidth=1.5), 
#             medianprops=dict(color="red", linewidth=2), showfliers=False)
# # Connecting mean points for Shapley Values
# plt.plot(shapley_mean, marker='o', color='red', linestyle='--', linewidth=2, label='Shapley Values')

# Boxplot for Sobol's Total Indices
sns.boxplot(data=data_sobol, boxprops=dict(facecolor='none', edgecolor='red', linestyle='--', linewidth=1), 
            whiskerprops=dict(color="red", linestyle='--', linewidth=1.5), capprops=dict(color="red", linestyle='--', linewidth=1.5), 
            medianprops=dict(color="red", linestyle='--', linewidth=2), showfliers=False)
# Connecting mean points for Sobol's Total Indices
plt.plot(sobol_mean, marker='D', markersize=10, color='red', markerfacecolor='red', linestyle='-', linewidth=3, label="Sobol's Total Indices")

# Boxplot for Shapley Values
sns.boxplot(data=data_shapley, boxprops=dict(facecolor='none', edgecolor='blue', linestyle='--', linewidth=1), 
            whiskerprops=dict(color="blue", linestyle='--', linewidth=1.5), capprops=dict(color="blue", linestyle='--', linewidth=1.5), 
            medianprops=dict(color="blue", linestyle='--', linewidth=2), showfliers=False)
# Connecting mean points for Shapley Values
plt.plot(shapley_mean, marker='*', markersize=10, color='blue', markerfacecolor='blue', linestyle='-', linewidth=3, label='Shapley Values')

# Enhance the visual appeal
plt.grid(True, linestyle='--', linewidth=0.7, alpha=0.7)
plt.xticks(range(len(num_of_features)), num_of_features, fontsize=16)
plt.yticks(fontsize=16)
plt.xlabel('Number of Features Left in the Model', fontsize=24)
plt.ylabel('R^2 Scores: Variance Explained', fontsize=24)
# plt.title('Comparison of Sobol\'s Total Indices and Shapley Values R^2 Scores', fontsize=20)
plt.legend(fontsize=24)
plt.tight_layout()

# Save plot to PDF file
plt.savefig('regression.pdf')

# Show plot
plt.show()