import numpy as np
import pandas as pd
import sklearn as sk
import sys
from sklearn.ensemble import RandomForestClassifier
from method import *
import shap
from sklearn.tree import DecisionTreeClassifier

# Set a random seed for reproducibility
np.random.seed(42)

# Number of samples
n_samples = 100

# Generate highly correlated features
mean = [0, 0, 0, 0, 0]
cov = [[1, 0.9, 0.9, 0.9, 0.9],
       [0.9, 1, 0.9, 0.9, 0.9],
       [0.9, 0.9, 1, 0.9, 0.9],
       [0.9, 0.9, 0.9, 1, 0.9],
       [0.9, 0.9, 0.9, 0.9, 1]]

# Generate the multivariate normal distribution
data = np.random.multivariate_normal(mean, cov, n_samples)

# Create a DataFrame
df = pd.DataFrame(data, columns=['Feature1', 'Feature2', 'Feature3', 'Feature4', 'Outcome'])

sobol_total = sobol_total_indices(df.drop('Outcome', axis=1), df['Outcome'])
print("Sobol' Total Indices:")
for feature, index in zip(df.columns[:-1], sobol_total):
    print(f"{feature}: {index:.4f}")

shapley = calculate_shapley_values(df.drop('Outcome', axis=1), df['Outcome'])
print("Shapley Values:")
for feature, value in zip(df.columns[:-1], shapley):
    print(f"{feature}: {value:.4f}")


# XOR function

# Generate binary features
feature1 = np.random.randint(0, 2, n_samples)
feature2 = np.random.randint(0, 2, n_samples)

# XOR outcome
outcome = np.logical_xor(feature1, feature2).astype(int)

# Create a DataFrame
df = pd.DataFrame({
    'Feature1': feature1,
    'Feature2': feature2,
    'Outcome': outcome
})

sobol_total = sobol_total_indices(df.drop('Outcome', axis=1), df['Outcome'])
print("Sobol' Total Indices:")
for feature, index in zip(df.columns[:-1], sobol_total):
    print(f"{feature}: {index:.4f}")

shapley = calculate_shapley_values(df.drop('Outcome', axis=1), df['Outcome'])
print("Shapley Values:")
for feature, value in zip(df.columns[:-1], shapley):
    print(f"{feature}: {value:.4f}")