from torch import nn
import torch
# import mlxtend.preprocessing as preprocessing
from sklearn.preprocessing import minmax_scale
# from mlxtend.preprocessing import minmax_scaling


class Adapter(nn.Module):
    def __init__(self, input_size, hidd_size, output_size):
        super(Adapter, self).__init__()

        self.adapter = nn.Sequential(nn.Linear(input_size, hidd_size),
                nn.ReLU(),
                nn.Linear(hidd_size, hidd_size),
                nn.ReLE(),
                nn.Linear(hidd_size, output_size))
        self.l1 = nn.Sequential(
            nn.Dropout(0.1),
            nn.Linear(input_size, output_size)
        )

    def forward(self, input_ids):
        return self.adapter(input_ids)
        # return self.relu(self.adapter(input_ids))


class Adapter2(nn.Module):
    def __init__(self, input_size, hidd_size, output_size):
        super(Adapter2, self).__init__()

        self.adapter = nn.Sequential(nn.Linear(output_size, hidd_size),
                                     #nn.ReLU(),
                                     #nn.Linear(hidd_size, hidd_size),
                                     #nn.ReLU(),
                                     nn.Linear(hidd_size, output_size))
        self.l1 = nn.Sequential(nn.Linear(input_size, output_size))

    def forward(self, input_ids):
        x = self.l1(input_ids)
        return self.adapter(x)


class LoRA(nn.Module):
    def __init__(self, input_size, hidd_size, output_size):
        super(LoRA, self).__init__()
        self.adapter = nn.Sequential(nn.Linear(input_size, hidd_size),
                                     nn.Linear(hidd_size, output_size))
        self.l1 = nn.Sequential(nn.Linear(input_size, output_size))

    def forward(self, input_ids):
        l1_out = self.l1(input_ids)
        adapter_out = self.adapter(input_ids)
        adapter_out = adapter_out.detach().cpu()
        scale_out = minmax_scale(adapter_out)
        scale_out = torch.Tensor(scale_out).cuda()

        return scale_out


class Scaled_PA(nn.Module):
    def __init__(self, input_size, hidd_size, output_size):
        super(Scaled_PA, self).__init__()
        self.adapter = nn.Sequential(nn.Linear(input_size, hidd_size),
                                     nn.ReLU(),
                                     nn.Linear(hidd_size, output_size))
        self.l1 = nn.Sequential(nn.Linear(input_size, output_size))

    def forward(self, input_ids):
        l1_out = self.l1(input_ids)
        adapter_out = self.adapter(input_ids)
        adapter_out = adapter_out.detach().cpu()
        scale_out = minmax_scale(adapter_out)
        scale_out = torch.Tensor(scale_out).cuda()

        return  scale_out
