import React from 'react';
import {Group, Rect, Text} from '@antv/g6-react-node';

const leafNodeContent = (classLabel, samples, opacity) => (
    <Rect style={{
        width: '100%',
        height: 'auto',
        justifyContent: 'center',
        alignItems: 'center',
    }}
          draggable>
        <Text
            style={{
                fill: '#1c1c1c',
                fontSize: 12,
                margin: [4, 3],
                opacity: opacity
            }}>
            Class:
        </Text>
        <Text
            style={{
                fill: '#000',
                margin: [0, 0, 8, 0],
                fontSize: 16,
                fontWeight: 'bold',
                opacity: opacity
            }}>
            {classLabel}
        </Text>
        <Text style={{ fill: '#242424', fontSize: 12, margin: [4, 0, 4, 0], opacity: opacity }}>
            samples = {samples}
        </Text>
    </Rect>
);

const colors = ['yellow', 'blue', 'red', 'green', 'orange', 'purple', 'lime', 'cyan', '#f33eda', '#C8F3A9']

const replaceDeltaSignHotfix = (inputString) => {
    if (inputString.includes('Neighb.') || inputString.includes('L.')) {
        return inputString.replace("≤", "≥").replace(">", "≥")
    }
    if (!inputString.includes('≤') && (inputString.includes('Prev.') || inputString.includes('Layer') ||
        inputString.includes('Input'))) {
        return inputString + ' ≤ 0.5';
    }
    return inputString
}

export const TreeNodeCard = ({ cfg }) => {
    const { title, classLabel, backgroundColor, samples, gini, opacity, state } = cfg;

    return (
        <Group draggable>
            <Rect
                style={{
                    width: 200,
                    height: 'auto',
                    fill: backgroundColor || '#fff',
                    stroke: '#ddd',
                    radius: [8],
                    justifyContent: 'center',
                    padding: [8, 0],
                    opacity: opacity,
                    cursor: backgroundColor ? 'default' : 'pointer'
                }}
                draggable
            >
                {classLabel ? leafNodeContent(classLabel, samples, opacity) : (
                    <Rect style={{
                        justifyContent: 'center',
                        alignItems: 'center',
                        cursor: 'pointer'
                    }}>
                        <Rect style={{
                            justifyContent: 'center',
                            alignItems: 'center',
                            flexDirection: 'row',
                            cursor: 'pointer'
                        }}>
                        <Rect
                            style={{
                                width: 10,
                                height: 10,
                                fill: colors[state],
                                radius: [5],
                                padding: [0, 0],
                                opacity: opacity,
                                margin: [2, 8, 0, 0],
                                cursor: 'pointer'
                            }}
                        />
                    <Text
                        style={{
                            fill: '#000',
                            margin: [4, 0, 0, 0],
                            fontSize: 16,
                            fontWeight: 'bold',
                            opacity: opacity,
                            cursor: 'pointer'
                        }}
                    >
                        {replaceDeltaSignHotfix(title)}
                    </Text>
                        </Rect>
                    <Text style={{ fill: '#8b8b8b', fontSize: 12, margin: [12, 0, 4, 0], opacity: opacity, cursor: 'pointer' }}>
                        samples = {samples}
                    </Text>
                        <Text style={{ fill: '#8b8b8b', fontSize: 12, margin: [4, 0, 8, 0], opacity: opacity, cursor: 'pointer' }}>
                            gini = {gini}
                        </Text>
                    </Rect>
                )}
            </Rect>
        </Group>
    );
};

