import React, {useEffect, useState} from 'react';
import {atom, useAtom} from 'jotai'
import Graphin, {Behaviors, GraphinContext} from '@antv/graphin';
import {createNodeFromReact} from '@antv/g6-react-node';
import {TreeNodeCard} from "./components/treeNode";
import {decisionPathAtom, selectedLayerAtom} from "./App";

export const cutoffValueAtom = atom(0.01)
export const selectedSampleAtom = atom(0)
export const selectedTreePruningAtom = atom(0)

Graphin.registerNode('test', createNodeFromReact(TreeNodeCard));

const {ZoomCanvas, DragNode} = Behaviors;

const walk = (node, callback) => {
    callback(node);
    if (node.children && node.children.length > 0) {
        node.children.forEach(child => {
            walk(child, callback);
        });
    }
};


const DecisionTreeCard = (props) => {

    React.useContext(GraphinContext);
    const graphRef = React.createRef(null);
    const {treeData} = props


    const [, setSelectedLayer] = useAtom(selectedLayerAtom)


    const [selectedDecisionPath] = useAtom(decisionPathAtom)

    const [treeD] = useState(treeData)

    React.useEffect(() => {
        if (graphRef.current) {
            const {graph} = graphRef.current;
            const handleNodeClick = e => {
                const nextLayer = e.item.get('model').layer
                if (nextLayer >= 0) {
                    setSelectedLayer(nextLayer);
                }

            };
            graph.on('node:click', handleNodeClick);
            return () => {
                graph.off('node:click', handleNodeClick);
            };
        }
    }, [graphRef]);


    useEffect(() => {
        if (graphRef.current) {
            const {graph} = graphRef.current;
            const cloneData = Object.assign({}, treeData);
            walk(cloneData, node => {
                if (selectedDecisionPath.length === 0) {
                    node.opacity = 1.0
                } else {
                    // console.log(selectedDecisionPath.includes(parseInt(node["node_id"])),selectedDecisionPath, node["node_id"])
                    if (selectedDecisionPath.includes(parseInt(node["node_id"]))) {
                        node.opacity = 1.0
                    } else {
                        node.opacity = 0.1
                    }
                }
            });
            graph.changeData(cloneData)
        }
    }, [graphRef, selectedDecisionPath]);

    useEffect(() => {
        if (graphRef.current) {
            const {graph} = graphRef.current;
            graph.changeData(treeData)
            graph.fitView(10)
        }
    }, [treeData]);

    const layout = {
        type: 'compactBox',
        direction: 'TB',
        getHeight: (d) => 60,
        getWidth: (d) => 200,
        getVGap: (d) => 40,
        getHGap: (d) => 10
    }
    return (
        <Graphin data={treeD} ref={graphRef} layout={layout} animate={false} defaultNode={{type: 'custom-node'}}
                 fitView fitViewPadding={32} width="100%" height="100%"
                 theme='light'>
            <ZoomCanvas/>
            <DragNode disabled/>
        </Graphin>
    );
};

export default DecisionTreeCard;
