
struct Options
    mode::String
    model_type::String
    x1::Array{Data,1}
    x2::Array{Data,1}
    n_total::Int64
    n_keep::Int64
    n_burn::Int64
    verbose::Bool
    use_hyperprior::Bool
    t_max::Int64 
    # MFM options
    gamma::Float64
    log_pk::String
    # DPM options
    alpha_random::Bool
    alpha::Float64
    # Jain-Neal split-merge options
    use_splitmerge::Bool
    n_split::Int64
    n_merge::Int64
    # RJMCMC options
    k_max::Int64
    # Partition distribution values
    a::Float64
    b::Float64
    log_v::Array{Float64,1}
    # Transport map options
    ot_ratio::Float64
    swap_iter::Int64
    swap_set_size::Int64
    temperature::Float64
    block_size::Union{Int64, Nothing}
    # Other
    n1::Int64
    n2::Int64
    # subset
    subset_ratio::Float64
    sub_swap_iter::Int64
    # upsampling option
    fill_with_centers::Bool
end

struct Result
    options::Options
    t::Array{Int16,1}
    N::Array{Int32,2}
    z::Array{Int16,2}
    T::Array{Int64,2}
    ids::Vector{Int64}
    theta::Vector{Vector{Theta}}
    keepers::Array{Int64,1}
    elapsed_time::Float64
    time_per_step::Float64
end