# README

## Overview

This is the anonymous code corresponding to the ICLR 2025 submssion: "Hadamard Representations: Augmenting Hyperbolic Tangents in RL"

## Requirements

To run this code, you need the following dependencies:

```bash
pip install -r requirements.txt
```

## Supervised learning Experiment

to run and show the supervised learning experiment, run the following command:

```bash
python3 supervised_learning.py
```

## DQN Atari

to run DQN Atari with a Hadamard representation while tracking metrics such as effective rank and dead neurons, run the following command:

```bash
python3 dqn_atari_HR.py --activation='tanh_HR'
```

For a tanh activation function with a Hadamard representation.
For a ReLU with a Hadaamrd representation:

```bash
python3 dqn_atari_HR.py --activation='relu_HR'
```

normal activations are also available:

```bash
python3 dqn_atari_HR.py --activation='tanh'
```
or 

```bash
python3 dqn_atari_HR.py --activation='silu'
```

## PPO Atari

to run PPO Atari using envpool with a Hadamard representation run:

```bash
python3 ppo_atari_HR.py --activation='tanh_HR'
```