class LTFConfig():

    def __init__(self, pred_len) -> None:

        # exp
        self.embed = 'timeF'
        self.task_name = "long_term_forecast"
        self.features = 'M'
        self.target = 'OT'
        self.label_len = 0
        self.seasonal_patterns = "Monthly"
        self.batch_size = 32
        self.num_workers = 16
        self.freq = 'h'
        self.ex_chn = 4
        self.seq_len = 96
        self.pred_len = pred_len

        # model component
        self.activ = "gelu"
        self.norm = None
        self.use_last_norm = True

        # loss
        self.loss_fn = 'mse'
        self.lambda_acf = 0.5
        self.lambda_mse = 0.1
        self.acf_cutoff = 2

        # optim
        self.grad_clip_val = 1
        self.patience = 5
        self.lr = 1e-3
        self.lr_factor = 0.5
        self.optim = "adamw"
        self.weight_decay = 0.1
        self.KAN_layers_num = 3
        self.MST_num = 2
        self.Patch_num = 4



class ETTm1_LTFConfig_96(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "ettm1"
        self.data = "ETTm1"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTm1.csv"
        self.in_chn = 7
        self.out_chn = 7
        self.batch_size = 96

        self.drop = 0.5
        self.patch_sizes = [56 , 26, 12, 6, 1]
        self.hid_chn = 4
        self.hid_len = 4
        self.hid_pred = 512
        self.hid_pch = 8
        self.KAN_layers_num = 5
        self.MST_num = 4
        self.Patch_num = 5


class ETTm1_LTFConfig_192(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "ettm1"
        self.data = "ETTm1"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTm1.csv"
        self.in_chn = 7
        self.out_chn = 7
        self.batch_size = 96

        self.drop = 0.5
        self.patch_sizes = [56 , 26, 12, 6, 1]
        self.hid_chn = 2
        self.hid_len = 4
        self.hid_pred = 512
        self.hid_pch = 12
        self.KAN_layers_num = 3
        self.MST_num = 4
        self.Patch_num = 4

class ETTm1_LTFConfig_336(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "ettm1"
        self.data = "ETTm1"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTm1.csv"
        self.in_chn = 7
        self.out_chn = 7
        self.batch_size = 96

        self.drop = 0.5
        self.patch_sizes = [56 , 26, 12, 6, 1]
        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 512
        self.hid_pch = 2
        self.KAN_layers_num = 3
        self.MST_num = 1
        self.Patch_num = 5

class ETTm1_LTFConfig_720(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "ettm1"
        self.data = "ETTm1"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTm1.csv"
        self.in_chn = 7
        self.out_chn = 7
        self.batch_size = 96

        self.drop = 0.5
        self.patch_sizes = [56 , 26, 12, 6, 1]
        self.hid_chn = 4
        self.hid_len = 4
        self.hid_pred = 512
        self.hid_pch = 8
        self.KAN_layers_num = 5
        self.MST_num = 4
        self.Patch_num = 5

class ETTm2_LTFConfig_96(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "ettm2"
        self.data = "ETTm2"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTm2.csv"

        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [56, 26, 12, 6, 1]
        self.hid_chn = 1
        self.hid_len = 8
        self.hid_pred = 512
        self.hid_pch = 8
        self.KAN_layers_num = 3
        self.MST_num = 1
        self.Patch_num = 4

class ETTm2_LTFConfig_192(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "ettm2"
        self.data = "ETTm2"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTm2.csv"

        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [56, 26, 12, 6, 1]
        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 512
        self.hid_pch = 8
        self.KAN_layers_num = 3
        self.MST_num = 2
        self.Patch_num = 5

class ETTm2_LTFConfig_336(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "ettm2"
        self.data = "ETTm2"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTm2.csv"

        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [56, 26, 12, 6, 1]
        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 512
        self.hid_pch = 8
        self.KAN_layers_num = 3
        self.MST_num = 1
        self.Patch_num = 4

class ETTm2_LTFConfig_720(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "ettm2"
        self.data = "ETTm2"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTm2.csv"

        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [56, 26, 12, 6, 1]
        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 512
        self.hid_pch = 4
        self.KAN_layers_num = 3
        self.MST_num = 1
        self.Patch_num = 4


class ETTh1_LTFConfig_96(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "etth1"
        self.data = "ETTh1"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTh1.csv"
        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [56, 42 , 26, 12, 6, 1]
        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 512
        self.hid_pch = 4
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 1
        self.Patch_num = 6

class ETTh1_LTFConfig_192(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "etth1"
        self.data = "ETTh1"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTh1.csv"
        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [56, 42 , 26, 12, 6, 1]
        self.hid_chn = 1
        self.hid_len = 8
        self.hid_pred = 512
        self.hid_pch = 4
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 5
        self.Patch_num = 6        

class ETTh1_LTFConfig_336(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "etth1"
        self.data = "ETTh1"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTh1.csv"
        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [56, 42 , 26, 12, 6, 1]
        self.hid_chn = 2
        self.hid_len = 8
        self.hid_pred = 512
        self.hid_pch = 8
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 5
        self.Patch_num = 3

class ETTh1_LTFConfig_720(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "etth1"
        self.data = "ETTh1"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTh1.csv"
        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [56, 42 , 26, 12, 6, 1]
        self.hid_chn = 1
        self.hid_len = 2
        self.hid_pred = 512
        self.hid_pch = 12
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 4
        self.Patch_num = 3

class ETTh2_LTFConfig_96(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "etth2"
        self.data = "ETTh2"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTh2.csv"
        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [58,42,14,7,1,1]
        self.hid_chn = 2
        self.hid_len = 8
        self.hid_pred = 512
        self.hid_pch = 8
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 5
        self.Patch_num = 6

class ETTh2_LTFConfig_192(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "etth2"
        self.data = "ETTh2"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTh2.csv"
        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [58,42,14,7,1,1]
        self.hid_chn = 2
        self.hid_len = 4
        self.hid_pred = 512
        self.hid_pch = 16
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 1
        self.Patch_num = 5

class ETTh2_LTFConfig_336(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "etth2"
        self.data = "ETTh2"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTh2.csv"
        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [58,42,14,7,1,1]
        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 512
        self.hid_pch = 12
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 4
        self.Patch_num = 5

class ETTh2_LTFConfig_720(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "etth2"
        self.data = "ETTh2"
        self.root_path = "./dataset/ETT-small/"
        self.data_path = "ETTh2.csv"
        self.in_chn = 7
        self.out_chn = 7

        self.drop = 0.5
        self.patch_sizes = [58,42,14,7,1,1]
        self.hid_chn = 1
        self.hid_len = 2
        self.hid_pred = 512
        self.hid_pch = 12
        self.weight_decay = 1
        self.KAN_layers_num = 4
        self.MST_num = 3
        self.Patch_num = 3

class Weather_LTFConfig_96(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "weather"
        self.data = "custom"
        self.root_path = "./dataset/weather/"
        self.data_path = "weather.csv"
        self.in_chn = 21
        self.out_chn = 21

        self.drop = 0.4
        self.patch_sizes = [26,11,7,2,1,1]
        self.hid_chn = 2
        self.hid_len = 2
        self.hid_pred = 256
        self.hid_pch = 8
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 1
        self.Patch_num = 3

class Weather_LTFConfig_192(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "weather"
        self.data = "custom"
        self.root_path = "./dataset/weather/"
        self.data_path = "weather.csv"
        self.in_chn = 21
        self.out_chn = 21

        self.drop = 0.4
        self.patch_sizes = [26,11,7,2,1,1]
        self.hid_chn = 1
        self.hid_len = 8
        self.hid_pred = 256
        self.hid_pch = 12
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 2
        self.Patch_num = 4

class Weather_LTFConfig_336(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "weather"
        self.data = "custom"
        self.root_path = "./dataset/weather/"
        self.data_path = "weather.csv"
        self.in_chn = 21
        self.out_chn = 21

        self.drop = 0.4
        self.patch_sizes = [26,11,7,2,1,1]
        self.hid_chn = 1
        self.hid_len = 4
        self.hid_pred = 256
        self.hid_pch = 4
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 3
        self.Patch_num = 6

class Weather_LTFConfig_720(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "weather"
        self.data = "custom"
        self.root_path = "./dataset/weather/"
        self.data_path = "weather.csv"
        self.in_chn = 21
        self.out_chn = 21

        self.drop = 0.4
        self.patch_sizes = [26,11,7,2,1,1]
        self.hid_chn = 1
        self.hid_len = 2
        self.hid_pred = 256
        self.hid_pch = 12
        self.weight_decay = 1
        self.KAN_layers_num = 3
        self.MST_num = 2
        self.Patch_num = 4

class Exchange_LTFConfig_96(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "exchange"
        self.data = "custom"
        self.root_path = "./dataset/exchange_rate/"
        self.data_path = "exchange_rate.csv"
        self.in_chn = 8
        self.out_chn = 8

        self.drop = 0.5
        self.patch_sizes = [59 , 26, 11, 7, 2, 1]

        self.hid_chn = 8
        self.hid_len = 8
        self.hid_pred = 256
        self.hid_pch = 16
        
        self.MST_num = 3
        self.KAN_layers_num = 5
        self.Patch_num = 5

class Exchange_LTFConfig_192(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "exchange"
        self.data = "custom"
        self.root_path = "./dataset/exchange_rate/"
        self.data_path = "exchange_rate.csv"
        self.in_chn = 8
        self.out_chn = 8

        self.drop = 0.5
        self.patch_sizes = [59 , 26, 11, 7, 2, 1]

        self.hid_chn = 2
        self.hid_len = 1
        self.hid_pred = 256
        self.hid_pch = 16
        
        self.MST_num = 4
        self.KAN_layers_num = 2
        self.Patch_num = 3

class Exchange_LTFConfig_336(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "exchange"
        self.data = "custom"
        self.root_path = "./dataset/exchange_rate/"
        self.data_path = "exchange_rate.csv"
        self.in_chn = 8
        self.out_chn = 8

        self.drop = 0.5
        self.patch_sizes = [59 , 26, 11, 7, 2, 1]

        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 256
        self.hid_pch = 12
        
        self.MST_num = 3
        self.KAN_layers_num = 3
        self.Patch_num = 3

class Exchange_LTFConfig_720(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "exchange"
        self.data = "custom"
        self.root_path = "./dataset/exchange_rate/"
        self.data_path = "exchange_rate.csv"
        self.in_chn = 8
        self.out_chn = 8

        self.drop = 0.5
        self.patch_sizes = [59 , 26, 11, 7, 2, 1]

        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 256
        self.hid_pch = 16
        
        self.MST_num = 2
        self.KAN_layers_num = 6
        self.Patch_num = 1

class Exchange_LTFConfig_96(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "exchange"
        self.data = "custom"
        self.root_path = "./dataset/exchange_rate/"
        self.data_path = "new_exchange_rate_masked.csv"
        self.in_chn = 21
        self.out_chn = 21

        self.drop = 0.5
        self.patch_sizes = [59 , 26, 11, 7, 2, 1]

        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 256
        self.hid_pch = 2
        
        self.MST_num = 3
        self.KAN_layers_num = 4
        self.Patch_num = 4

class Exchange_LTFConfig_192(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "exchange"
        self.data = "custom"
        self.root_path = "./dataset/exchange_rate/"
        self.data_path = "new_exchange_rate_masked.csv"
        self.in_chn = 21
        self.out_chn = 21

        self.drop = 0.5
        self.patch_sizes = [59 , 26, 11, 7, 2, 1]

        self.hid_chn = 1
        self.hid_len = 1
        self.hid_pred = 256
        self.hid_pch = 12
        
        self.MST_num = 3
        self.KAN_layers_num = 5
        self.Patch_num = 4

class Exchange_LTFConfig_336(LTFConfig):

    def __init__(self, pred_len) -> None:
        super().__init__(pred_len)
        self.name = "exchange"
        self.data = "custom"
        self.root_path = "./dataset/exchange_rate/"
        self.data_path = "new_exchange_rate_masked.csv"
        self.in_chn = 21
        self.out_chn = 21

        self.drop = 0.5
        self.patch_sizes = [59 , 26, 11, 7, 2, 1]

        self.hid_chn = 2
        self.hid_len = 8
        self.hid_pred = 256
        self.hid_pch = 2
        
        self.MST_num = 3
        self.KAN_layers_num = 2
        self.Patch_num = 6
