import numpy as np
import math

# Job parameters.
run_id = 'hmdb_swin_adv1.0ent4.0gpen10.0'
eval = False
arch = 'swin_t'
saved_model = None

# Dataset parameters.
dataset = 'hmdb51'
num_classes = 51
num_frames = 16
fix_skip = 2
num_modes = 1
data_percentage = 0.1
stillmix = 'none'
prob_aug = 0.75

# Training parameters.
batch_size = 2
v_batch_size = 8
num_workers = 4
learning_rate = 1e-5
num_epochs = 1
temporal_weight = 1.0
spatial_weight = 1.0
entropy_weight = 4.0
gradpen_weight = 10.0
warmup_array = list(np.linspace(0.01, 1, 5) + 1e-9)
warmup = len(warmup_array)
momentum = 0.9
weight_decay = 1e-2

lr_scheduler = 'cosine'
cosine_lr_array = list(np.linspace(0.01, 1, 5)) + [(math.cos(x) + 1)/2 for x in np.linspace(0, math.pi/0.99, num_epochs)]
val_freq = 1
save_every = 5
opt_type = 'adamw' # 'sgd' # 'adam'

# Training augmentation params.
reso_h = 224
reso_w = 224

# Tracking params.
wandb = False