import json
import numpy as np

json_files=[
    "../../mt_bench/7b-final-seed2024/GCSpS0.1binary5.txt",
    "../../mt_bench/7b-final-seed2024/spechub0.1binary5.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement0.1binary5.txt",
    "../../mt_bench/7b-final-seed2024/RRS0.1binary5.txt",
    "../../mt_bench/7b-final-seed2024/GCSpS0.6binary5.txt",
    "../../mt_bench/7b-final-seed2024/spechub0.6binary5.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement0.6binary5.txt",
    "../../mt_bench/7b-final-seed2024/RRS0.6binary5.txt",
    "../../mt_bench/7b-final-seed2024/GCSpS1binary5.txt",
    "../../mt_bench/7b-final-seed2024/spechub1binary5.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement1binary5.txt",
    "../../mt_bench/7b-final-seed2024/RRS1binary5.txt",
    "../../mt_bench/7b-final-seed2024/GCSpS0.1branch4.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement0.1branch4.txt",
    "../../mt_bench/7b-final-seed2024/RRS0.1branch4.txt",
    "../../mt_bench/7b-final-seed2024/GCSpS0.6branch4.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement0.6branch4.txt",
    "../../mt_bench/7b-final-seed2024/RRS0.6branch4.txt",
    "../../mt_bench/7b-final-seed2024/GCSpS1branch4.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement1branch4.txt",
    "../../mt_bench/7b-final-seed2024/RRS1branch4.txt",

    "../../mt_bench/7b-final-seed2024/GCSpS0.1mc_sim_7b_63.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement0.1mc_sim_7b_63.txt",
     "../../mt_bench/7b-final-seed2024/RRS0.1mc_sim_7b_63.txt",
     "../../mt_bench/7b-final-seed2024/GCSpS0.6mc_sim_7b_63.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement0.6mc_sim_7b_63.txt",
     "../../mt_bench/7b-final-seed2024/RRS0.6mc_sim_7b_63.txt",
     "../../mt_bench/7b-final-seed2024/GCSpS1mc_sim_7b_63.txt",
    "../../mt_bench/7b-final-seed2024/RRS_wo_replacement1mc_sim_7b_63.txt",
     "../../mt_bench/7b-final-seed2024/RRS1mc_sim_7b_63.txt",
]




for jsonl_file in json_files:
    data=[]
    with open(jsonl_file, 'r', encoding='utf-8') as file:
        for line in file:
            json_obj = json.loads(line)
            data.append(json_obj)

    alphas=[0 for _ in range(5)]
    alphas_num=[0 for _ in range(5)]
    for datapoint in data:
        qid=datapoint["question_id"]
        answer=datapoint["choices"][0]['turns']
        tokens=sum(datapoint["choices"][0]['new_tokens'])
        ids = sum(datapoint["choices"][0]['idxs'])
        alpha=datapoint["choices"][0]['alpha']
        alpha_num = datapoint["choices"][0]['alpha_num']
        for i in range(len(alpha)):
            alphas[i]+=alpha[i]
            alphas_num[i] += alpha_num[i]
    accept_num = np.sum(np.array(alphas))
    all_num = np.sum(np.array(alphas_num))
    list_result = np.zeros(all_num)
    list_result[:accept_num] = 1
    mean_std = np.std(list_result) / np.sqrt(all_num)
    avg_acceptance = accept_num/all_num
    # print(avg_acceptance*100)
    # print(mean_std * 100)
    
    print(f"Overall Acceptance Rate of {jsonl_file}: {100*avg_acceptance:.1f}")
    print(f"Standard Deviation of {jsonl_file}: {100*mean_std:.1f}")

    # ar=np.array(alphas)/np.array(alphas_num)
    # print(np.round(avg_acceptance, 2))
    
