import torch

def logminusexp(logp1, logp2):
    """
    logp1: torch.tensor, must be of full shape
    logp2: torch.tensor or scalar
    return: torch.tensor, log(exp(logp1)-exp(logp2))
    """
    return torch.where(
        logp1 > logp2,
        logp1 + torch.log(-torch.expm1(logp2 - logp1)),
        torch.full_like(logp1, -float("inf")),
    )

from . import theory
from . import gen
from . import verify
