import argparse
import os
import numpy as np
import random

def get_config(set_arg=None):
    parser = argparse.ArgumentParser(description='experiments on various ')
    # help Display description information for candidate parameters
    parser.add_argument('--n_nodes', type=int, default=20, help='')
    parser.add_argument('--ER', type=int, default=2, help='')
    parser.add_argument('--size', type=int, default=2, help='')
    parser.add_argument('--graph_type', type=str, default='ER', help='')
    parser.add_argument('--random', type=int, default=0, help='')
    
    parser.add_argument('--method', type=str, default='linear', help='')
    parser.add_argument('--sem_type', type=str, default='gauss', help='')
    parser.add_argument('--loss_type', type=str, default='pdf', help='')

    parser.add_argument('--prior_type', type=str, default='exist', help='')
    parser.add_argument('--confidence', type=float, default=0.9, help='')
    parser.add_argument('--proportion', default=0.9, help='')
    parser.add_argument('--error_prior_proportion', default=0., help='')
    parser.add_argument('--error_prior_type', type=str, default='reverse direct', help='')

    parser.add_argument('--alg', type=str, default='notears', help='')
    parser.add_argument('--scale', type=str, default='no', help='')
    parser.add_argument('--adaptive_degree', type=float, default=0.95, help='')
    parser.add_argument('--lambda1', type=float, default=0.1, help='')

    parser.add_argument('--test', type=int, default=1, help='')
    args = parser.parse_args()

    if type(args.proportion)==str:
        args.proportion=eval(args.proportion)
    if type(args.error_prior_proportion)==str:
        args.error_prior_proportion=eval(args.error_prior_proportion)

    if set_arg != None and args.test: 
        for key in set_arg:
            setattr(args, key, set_arg[key])
    
    args.n_edges=args.ER*args.n_nodes

    if 'NE' in args.sem_type:
        args.loss_type = 'nll'
    else:
        args.loss_type = 'pdf'

    return args

def normalize(X,normalize_type):
    std_devs = np.std(X, axis=0, ddof=0)  
    if normalize_type=='no':
        X_normalized = X
    elif normalize_type=='std':
        X_normalized = (X - np.mean(X, axis=0)) / std_devs
    elif normalize_type=='part':
        X_normalized = (X - np.mean(X, axis=0)) / (std_devs**0.5)
    elif normalize_type=='mean':
        X_normalized = (X - np.mean(X, axis=0))
    return X_normalized

def read_csv(path):
    import pandas as pd
    df = pd.read_csv(path)
    df.fillna(df.mean(numeric_only=True), inplace=True)
    return df


