import numpy as np
import torch
from constants import input_dim, output_dim

def gen_data(n, true_function, rng):
    scale =  1.0
    data = []
    xs = scale * 2 * (rng.random((n, input_dim)) - 0.5)
    xs = torch.as_tensor(xs, dtype=torch.float32)
    ys = torch.zeros((n, output_dim))
    for i in range(n):
        ys[i, :] = true_function.forward(xs[i, :])
        data.append((xs[i, :], ys[i, :]))

    return data