import torch.nn as nn
import torch.nn.functional as F
import torch
from constants import input_dim, output_dim


class SixLayerNeuralNet(nn.Module):

    def __init__(self):
        super(SixLayerNeuralNet, self).__init__()
        self.fc1 = nn.Linear(input_dim, 10)
        self.fc2 = nn.Linear(10, 10)
        self.fc3 = nn.Linear(10, 10)
        self.fc4 = nn.Linear(10, 10)
        self.fc5 = nn.Linear(10, 10)
        self.fc6 = nn.Linear(10, output_dim)
        self.act = nn.Identity()

    def forward(self, x):
        x = self.act(self.fc1(x))
        x = self.act(self.fc2(x))
        x = self.act(self.fc3(x))
        x = self.act(self.fc4(x))
        x = self.act(self.fc5(x))
        x = self.fc6(x)

        return x

class FourLayerNeuralNet(nn.Module):

    def __init__(self):
        super(FourLayerNeuralNet, self).__init__()
        self.fc1 = nn.Linear(input_dim, 10)
        self.fc2 = nn.Linear(10, 10)
        self.fc3 = nn.Linear(10, 10)
        self.fc4 = nn.Linear(10, output_dim)
        self.act = nn.Identity()

    def forward(self, x):
        x = self.act(self.fc1(x))
        x = self.act(self.fc2(x))
        x = self.act(self.fc3(x))
        x = self.fc4(x)

        return x

class TwoLayerNeuralNet(nn.Module):

    def __init__(self):
        super(TwoLayerNeuralNet, self).__init__()
        self.fc1 = nn.Linear(input_dim, 10)
        self.fc2 = nn.Linear(10, output_dim)
        self.act = nn.Identity()

    # 順伝播
    def forward(self, x):
        x = self.act(self.fc1(x))
        x = self.fc2(x)

        return x


class SixLayerNeuralNet_small(nn.Module):

    def __init__(self):
        super(SixLayerNeuralNet_small, self).__init__()
        self.fc1 = nn.Linear(input_dim, 5)
        self.fc2 = nn.Linear(5, 5)
        self.fc3 = nn.Linear(5, 5)
        self.fc4 = nn.Linear(5, 5)
        self.fc5 = nn.Linear(5, 5)
        self.fc6 = nn.Linear(5, output_dim)
        self.act = nn.Identity()

    def forward(self, x):
        x = self.act(self.fc1(x))
        x = self.act(self.fc2(x))
        x = self.act(self.fc3(x))
        x = self.act(self.fc4(x))
        x = self.act(self.fc5(x))
        x = self.fc6(x)

        return x

class FourLayerNeuralNet_small(nn.Module):

    def __init__(self):
        super(FourLayerNeuralNet_small, self).__init__()
        self.fc1 = nn.Linear(input_dim, 5)
        self.fc2 = nn.Linear(5, 5)
        self.fc3 = nn.Linear(5, 5)
        self.fc4 = nn.Linear(5, output_dim)
        self.act = nn.Identity()

    def forward(self, x):
        x = self.act(self.fc1(x))
        x = self.act(self.fc2(x))
        x = self.act(self.fc3(x))
        x = self.fc4(x)

        return x

class TwoLayerNeuralNet_small(nn.Module):

    def __init__(self):
        super(TwoLayerNeuralNet_small, self).__init__()
        self.fc1 = nn.Linear(input_dim, 5)
        self.fc2 = nn.Linear(5, output_dim)
        self.act = nn.Identity()

    def forward(self, x):
        x = self.act(self.fc1(x))
        x = self.fc2(x)

        return x

