import torch
import torch.nn as nn
import torch.optim as optim
from torch.optim.lr_scheduler import ReduceLROnPlateau
import torch.nn.functional as F


class LeNet(nn.Module):
    def __init__(self, input_image_channels):
        super(LeNet, self).__init__()
        self.conv1 = nn.Conv2d(input_image_channels, 6, kernel_size=(5,5), stride=(1, 1))
        self.conv2 = nn.Conv2d(6, 16, kernel_size=(5, 5), stride=(1, 1))
        self.max_pool = nn.MaxPool2d(kernel_size=(2, 2), stride=(2, 2))
        self.bn1 = nn.BatchNorm2d(6)
        self.bn2 = nn.BatchNorm2d(16)
        self.fc1 = nn.Linear(4 * 4 * 16, 120)
        self.fc2 = nn.Linear(120, 84)
        self.fc3 = nn.Linear(84, 10)

    def  forward(self, x):
        x = F.relu(self.bn1(self.conv1(x)))
        x = self.max_pool(x)
        x = F.relu(self.bn2(self.conv2(x)))
        x = self.max_pool(x)
        x = x.view(-1, 4 * 4 * 16)
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        return x


class FourLayerNeuralNet(nn.Module):

    # 使用するオブジェクトを定義
    def __init__(self):
        super(FourLayerNeuralNet, self).__init__()
        self.fc1 = nn.Linear(1 * 28 * 28, 64)
        self.fc2 = nn.Linear(64, 64)
        self.fc3 = nn.Linear(64, 64)
        self.fc4 = nn.Linear(64, 10)

    # 順伝播
    def forward(self, x):
        x = x.view(x.size()[0], -1)
        x = torch.sigmoid(self.fc1(x))
        x = torch.sigmoid(self.fc2(x))
        x = torch.sigmoid(self.fc3(x))
        x = self.fc4(x)

        return x


class ThreeLayerNeuralNet(nn.Module):

    # 使用するオブジェクトを定義
    def __init__(self):
        super(ThreeLayerNeuralNet, self).__init__()
        self.fc1 = nn.Linear(1 * 28 * 28, 64)
        self.fc2 = nn.Linear(64, 64)
        self.fc3 = nn.Linear(64, 10)

    # 順伝播
    def forward(self, x):
        x = x.view(x.size()[0], -1)
        x = torch.sigmoid(self.fc1(x))
        x = torch.sigmoid(self.fc2(x))
        x = self.fc3(x)

        return x


class TwoLayerNeuralNet(nn.Module):

    # 使用するオブジェクトを定義
    def __init__(self):
        super(TwoLayerNeuralNet, self).__init__()
        self.fc1 = nn.Linear(1 * 28 * 28, 200)
        self.fc2 = nn.Linear(200, 10)

    # 順伝播
    def forward(self, x):
        x = x.view(x.size()[0], -1)
        x = torch.sigmoid(self.fc1(x))
        x = self.fc2(x)

        return x
