import time

def setup(env, data_row):


    env.run_command('code --disable-workspace-trust --no-sandbox --disable-gpu /testbed', wait=10)
    env.run_command('git config core.fileMode false', workdir = '/testbed')
    env.run_command('git config --global core.fileMode false', workdir = '/testbed')
    # breakpoint()
    env.run_command('git config --global --add safe.directory /testbed', workdir = '/testbed')

    break_flag = False
    while True:
        for potential_window_names in ["Code - OSS", "VS Code"]:
            env.run_command('wmctrl -i -r $(wmctrl -l | grep "'+potential_window_names+'" | awk \'{print $1}\') -e 0,0,0,1920,1080', wait=5)
            window_info = env.run_command('wmctrl -lG | grep "'+potential_window_names+'"')[0]
            if '1920 1080' in window_info:
                print('Window resized')
                break_flag = True
                break
            print('Trying to resize window', window_info)
            time.sleep(5)
            
        if break_flag:
            break

    for file in ['README.md', 'README', 'README.txt', 'README.rst']:
        try:    
            # breakpoint()
            som_infos = env.get_som_image(env.render())
            solution_id = next(k for k, v in som_infos[0][3].items() if file in v)
            env.run_command(f'xdotool mousemove {som_infos[0][1][solution_id][0]} {som_infos[0][1][solution_id][1]} click --repeat 2 1')
            break
        except Exception as e:
            print(e)


