from typing import List


class Matrix:
    def __init__(self, content: List[List[int]]) -> None:
        num_cols = None
        for row in content:
            if num_cols is None:
                num_cols = len(row)
            else:
                if len(row) != num_cols:
                    raise ValueError
        self.content = content

    def transpose(self) -> None:
        new_content = [
            [0 for i in range(len(self.content))] for i in range(len(self.content[0]))
        ]
        for row in range(len(self.content)):
            for col in range(len(self.content[row])):
                new_content[col][row] = self.content[row][col]
        self.content = new_content

    def determinant(self) -> int:
        assert len(self.content) == len(self.content[0])

        if len(self.content) == 2:
            return (
                self.content[0][0] * self.content[1][1]
                - self.content[0][1] * self.content[1][0]
            )
        elif len(self.content) == 3:
            t = self.content
            return (
                t[0][0] * (t[1][1] * t[2][2] - t[1][2] * t[2][1])
                - t[1][0] * (t[0][1] * t[2][2] - t[0][2] * t[2][1])
                + t[2][0] * (t[0][1] * t[1][2] - t[0][2] * t[1][1])
            )
        else:
            raise NotImplementedError