from typing import List, Tuple
from math import sqrt


class Label:
    def __init__(self, name: str) -> None:
        self.name = name

    def __eq__(self, __value: object) -> bool:
        if isinstance(__value, Label):
            return __value.name == self.name
        return False

    def __hash__(self) -> int:
        return self.name.__hash__()


class Point:
    def __init__(self, x: int, y: int, label: Label | None) -> None:
        self.x = x
        self.y = y
        self.label = label

    def distance(self, other: "Point") -> float:
        return sqrt((self.x - other.x) ** 2 + (self.y - other.y) ** 2)

    def knn(self, others: List["Point"], k: int) -> Label:
        assert k > 0
        assert others
        assert not self.label
        assert len(others) >= k
        distances = map(lambda point: (point.label, self.distance(point)), others)
        votes = {}
        for label, _ in sorted(distances, key=lambda tup: tup[1])[:k]:
            if label not in votes.keys():
                votes[label] = 1
            else:
                votes[label] += 1
        return max(votes.items(), key=lambda item: item[1])[0]