import pandas as pd

class StringOperations:
    """A class containing a series of string operations"""

    def remove_duplicates(text):
        """Returns the text with only unique characters"""
        unique = []
        for char in text:
            if char not in unique:
                unique.append(char)
        return ''.join(unique)
    
    def word_reversal(text):
        """Returns the text with words reversed"""
        sentences = text.split(' ')
        return ' '.join(reversed(sentences))
    
    def remove_vowels(text):
        """Returnes the text with vowels removed"""
        vowels = 'aeiou'
        return ''.join(char for char in text if char.lower() not in vowels)
    
def calculate_all_properties(text):
    properties = [StringOperations.remove_vowels(text), StringOperations.word_reversal(text), StringOperations.remove_duplicates(text)]
    return properties

def multi_apply(data, col, colnames):
    properties = data[col].apply(calculate_all_properties)
    properties_columns = pd.DataFrame(properties.tolist(), columns=colnames)
    return pd.concat([data, properties_columns], axis=1)