# Code for Monte Carlo Graph Search
This is the code for paper "Monte Carlo Graph Search" (MCGS). MCGS is a planning method for planning in continuous action space.

## Code structure
The code is structured in the following way:
- `agents`:

    |_ `mcgs.py`: we define the mcgs agent in this file
- `configs`: all configs used in the method are defined here
- `toy_envs`: includes two customed environments: `two_d_navigation` and `two_d_reacher` for understanding the behavior and properties of the MCGS.
- `utils`: helper functions are defined under this folder
- `wrappers`: environment wrappers

## How to run the code
1. Install the dependencies:
```shell
conda env install -f environments.yaml
conda activate mcgs
```

2. We use `wandb` for logging, if you haven't used it before, login with
```shell
wandb login
```

3. Run the code by
```shell
python3 run_mcgs.py use_wandb=true
```
