import pandas as pd
import matplotlib.pyplot as plt

def plot_loss_from_csv(csv_file_path):
    # Read the CSV file into a pandas DataFrame
    df = pd.read_csv(csv_file_path)
    
    # Define the color schemes for the lines
    color_scheme = {
        '1': 'orange',
        '2': 'darkred',
        '3': 'lightgreen',
        '4': 'lightblue'
    }
    
    # Define the markers for the lines
    marker_scheme = {
        'f1': 'o',  # Circle
        'f2': 's'   # Square
    }
    
    # Plot the lines
    for key in color_scheme:
        plt.plot(df[f'{key}-f1'], color=color_scheme[key], marker=marker_scheme['f1'], linestyle='-', label=f'{key}-f1')
        plt.plot(df[f'{key}-f2'], color=color_scheme[key], marker=marker_scheme['f2'], linestyle='-', label=f'{key}-f2')
    
    # Configure the plot
    plt.xlabel('Steps')
    plt.ylabel('Loss')
    plt.title('Loss Over Steps')
    plt.grid(True)
    
    # Save the figure
    plt.savefig('loss_over_steps.png')
    
    # Display the plot
    plt.show()

# Use the function assuming the CSV file is named 'data.csv'
plot_loss_from_csv('data.csv')