# 设置读取的 checkpoint 路径
export PRETRAIN_CHKPT='/root/autodl-tmp/img2img_unlearning/mae-main/checkpoints/mae_visualize_vit_large_ganloss.pth'

# 设置 forget、retain 数据集的路径
export DATA_PATH_FORGET='/root/autodl-tmp/img2img_unlearning/mae-mage-data/imagenet_forget_10_100'
export DATA_PATH_RETAIN='/root/autodl-tmp/img2img_unlearning/mae-mage-data/imagenet_retain_10_100'

# 设置模型保存的路径
# method-beta-encoder-clone-lr-all-con (1-encoder-clone-5e-5)
export OUTPUT_DIR='/root/autodl-tmp/img2img_unlearning/mae-main/output_dir/ours-1encoder-1clone-1e-4-all-0.60-random-0.5-0.8'

# 选择 unlearning 的方法，包括 max_loss、noisy_label、retain_label、random_encoder、iclr、ours
export METHOD='ours'

python main_pretrain.py \
    --accum_iter 1 \
    --batch_size 32 \
    --data_path_forget ${DATA_PATH_FORGET} \
    --data_path_retain ${DATA_PATH_RETAIN} \
    --model mae_vit_large_patch16 \
    --chkpt ${PRETRAIN_CHKPT} \
    --norm_pix_loss \
    --mask_ratio 0.5 \
    --epochs 5 \
    --warmup_epochs 2\
    --blr 1e-4 --weight_decay 0.0 \
    --method ${METHOD} \
    --output_dir ${OUTPUT_DIR}

    