#!/bin/bash

# custom config
DATA=~/CoOp/data/
TRAINER=$1
DATASET=$2
CFG=$3  # rn50, rn101, vit_b32 or vit_b16
VT=$4


python stability_extensibility.py \
--root ${DATA} \
--trainer ${TRAINER} \
--dataset-config-file configs/datasets/${DATASET}.yaml \
--config-file configs/trainers/CoOp/${CFG}.yaml \
--target-label-dir output/${TRAINER}/${CFG}/${DATASET}/stability/base_prompt/ \
--eval-only \
--incremental-evaluation \
--V-T ${VT} \
--trials 2

# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotCLIP my_cifar100 vit_b32 aquatic
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotCLIP imagenet vit_b32 garment
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotDeCLIP my_cifar100 vit_b32_declip aquatic
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotDeCLIP imagenet vit_b32_declip garment
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotSLIP my_cifar100 vit_b16_slip_ep100 aquatic
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotSLIP imagenet vit_b16_slip_ep100 garment

# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotCLIP flowers_pets_cars vit_b32 OxfordFlowers
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotCLIP flowers_pets_foods vit_b32 OxfordFlowers
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotCLIP dtd_eurosat_cars vit_b32 DescribableTextures
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotCLIP cifar100_caltech101_sun397 vit_b32 MYCIFAR100
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotCLIP cifar10_cifar100_imagenet vit_b32 MYCIFAR10
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility.sh ZeroshotCLIP2 cifar100_caltech101_sun397 vit_b32 MYCIFAR100