#!/bin/bash

# custom config
DATA=~/CoOp/data/
TRAINER=CoOp

DATASET=$1
CFG=$2  # config file
CTP=$3  # class token position (end or middle)
NCTX=$4  # number of context tokens
SHOTS=$5  # number of shots (1, 2, 4, 8, 16)
CSC=$6  # class-specific context (False or True)
VT=$7

for SEED in 1
do
    DIR=${DATASET}/${TRAINER}/${CFG}_${SHOTS}shots/nctx${NCTX}_csc${CSC}_ctp${CTP}/seed${SEED}
    MODEL_DIR=output/${DIR}
    OUTPUT_DIR=output/${TRAINER}/${CFG}_${SHOTS}shots/nctx${NCTX}_csc${CSC}_ctp${CTP}/seed${SEED}/${DATASET}/stability/base_prompt/

    python stability_extensibility.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/CoOp/${CFG}.yaml \
    --model-dir ${MODEL_DIR} \
    --target-label-dir ${OUTPUT_DIR} \
    --eval-only \
    --incremental-evaluation \
    --V-T ${VT} \
    --trials 100 \
    --load-epoch 50 \
    TRAINER.COOP.N_CTX ${NCTX} \
    TRAINER.COOP.CSC ${CSC} \
    TRAINER.COOP.CLASS_TOKEN_POSITION ${CTP}
done

# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility_for_coop.sh my_cifar100 vit_b16_ep50 end 16 -1 False aquatic