#!/bin/bash

# custom config
DATA=~/CoOp/data/
TRAINER=$1
DATASET=$2
CFG=$3  # rn50, rn101, vit_b32 or vit_b16
VT=$4
LAMBDA=$5
RETRIEVED_NUM=$6
MODALITY=$7  # image, text


python stability_extensibility.py \
--root ${DATA} \
--trainer ${TRAINER} \
--dataset-config-file configs/datasets/${DATASET}.yaml \
--config-file configs/trainers/CoOp/${CFG}.yaml \
--target-label-dir output/${TRAINER}/${CFG}/${DATASET}/stability/base_prompt_pretrained_${MODALITY}_enhanced_shift_${LAMBDA}_K${RETRIEVED_NUM} \
--eval-only \
--incremental-evaluation \
--V-T ${VT} \
--trials 100 \
--${MODALITY}-enhanced-shift \
--shift-lambda ${LAMBDA} \
--retrieved-num ${RETRIEVED_NUM}

# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility_w_shifted_text.sh ZeroshotCLIP my_cifar100 vit_b32 aquatic 0.1 100 image
# CUDA_VISIBLE_DEVICES=0 bash scripts/stability_extensibility_w_shifted_text.sh ZeroshotCLIP my_cifar100 vit_b32 aquatic 0.5 100 text
