import glfw
import numpy as np

def initialize_viewer(env,render_mode = 'rgb_array'):
    env.render()
    if render_mode == 'rgb_array':
        glfw.hide_window(env.viewer.window)
    
def set_camera(env, lookat=(0.0, 0.0, 0.5), distance=4.0, azimuth=90, elevation=-20):
    cam = env.viewer.cam
    cam.type = 0  # CAMERA_FREE
    cam.fixedcamid = -1
    cam.azimuth = azimuth
    cam.elevation = elevation
    cam.distance = distance
    cam.lookat[:] = lookat

def render(env,test_env,type = 'human'):
    if 'dir' in test_env:
        if 'cheetah' in test_env:
            set_camera(env, lookat=(0, 0, 0), distance=8.0, azimuth=90, elevation=-50)
        else:
            set_camera(env, lookat=(0, 0, 0), distance=8.0, azimuth=0, elevation=-50)
    if 'goal' in test_env:
        set_camera(env, lookat=(0, 0, 0), distance=10.0, azimuth=90, elevation=-50)

    frame = env.render(type)
    add_markers(env,test_env)
    return frame

def vector_to_rotation_matrix(vec):
    """
    Create a rotation matrix where `vec` is the new Z axis.
    """
    z = vec / np.linalg.norm(vec)
    x = np.array([1.0, 0.0, 0.0])
    if np.allclose(z, x) or np.allclose(z, -x):
        x = np.array([0.0, 1.0, 0.0])  # avoid colinearity
    y = np.cross(z, x)
    y /= np.linalg.norm(y)
    x = np.cross(y, z)
    rot = np.stack([x, y, z], axis=1)  # shape (3, 3)
    return rot

def add_markers(env,test_env):
    # env.viewer._markers.clear()
    if test_env == None:
        pass
    elif test_env == 'cheetah-vel':
        pass
    elif test_env == 'cheetah-dir':   
        arrow_vec = np.array([-1.0, 0.0, 0.0])
        arrow_vec = arrow_vec / np.linalg.norm(arrow_vec)
        rot_mat = vector_to_rotation_matrix(arrow_vec)
        env.viewer.add_marker(
            pos=[arrow_vec[0],arrow_vec[1], 0.05],
            size=[0.02, 0.02, 0.5],  # radius, radius, half-length
            rgba=[0, 1, 0, 1],
            mat=rot_mat,
            label="Direction",
            type=3
        )
    elif test_env == 'ant-goal':
        env.viewer.add_marker(
            pos=[env._goal[0], env._goal[1], 0],        # 표시할 위치 (world 좌표계)
            size=[0.4, 0.4, 0.4], # 마커 크기 (작은 구 모양)
            rgba=[0, 1, 0, 1],     # 색상 (빨간색)
            label="Goal",         # 마커에 라벨 표시 (선택적)
            type=2
        )
    elif test_env == 'ant-dir':
        arrow_vec = np.array([np.cos(env._goal),np.sin(env._goal), 0.0])
        arrow_vec = arrow_vec / np.linalg.norm(arrow_vec) 
        rot_mat = vector_to_rotation_matrix(arrow_vec)
        env.viewer.add_marker(
            pos=[arrow_vec[0],arrow_vec[1], 0.05],
            size=[0.02, 0.02, 0.5],  # radius, radius, half-length
            rgba=[0, 1, 0, 1],
            mat=rot_mat,
            label="Direction",
            type=3
        )
    elif test_env == 'humanoid-dir':
        arrow_vec = np.array([np.cos(env._goal),np.sin(env._goal), 0.0])
        arrow_vec = arrow_vec / np.linalg.norm(arrow_vec)
        rot_mat = vector_to_rotation_matrix(arrow_vec)
        env.viewer.add_marker(
            pos=[arrow_vec[0],arrow_vec[1], 0.05],
            size=[0.02, 0.02, 0.5],  # radius, radius, half-length
            rgba=[0, 1, 0, 1],
            mat=rot_mat,
            label="Direction",
            type=3
        )