# Quick commands (example: cheetah-vel). Copy-paste this whole block.

# =========================
# APB
# =========================
# Meta-training
python launch_sr2.py --train_env='cheetah-vel'

# Adaptation after convergence
# (adapt on the same task)
python meta_test2.py --test_env='cheetah-vel'
# (use a backbone meta-trained on cheetah-vel to adapt to cheetah-dir, i.e., OOD)
python meta_test2.py --test_env='cheetah-dir' --train_env='cheetah-vel'

# Useful flags
# --scratch       : compare against standard RL (train from scratch, no backbone)
# --action_noise  : use TD3-style action noise for exploration
# --no_backbone   : use a randomly initialized backbone (layers only)
# Examples:
# python meta_test2.py --test_env='cheetah-vel' --scratch
# python meta_test2.py --test_env='cheetah-vel' --action_noise
# python meta_test2.py --test_env='cheetah-vel' --no_backbone


# =========================
# MAML / ANIL
# =========================
# Meta-training
python launch_maml.py --train_env='cheetah-vel'
python launch_anil.py --train_env='cheetah-vel'

# Adaptation after convergence
python maml_test.py --test_env='cheetah-vel'
python anil_test.py --test_env='cheetah-vel'


# =========================
# CAVIA
# =========================
# Meta-training
python launch_cavia.py --train_env='cheetah-vel'

# Adaptation after convergence
python cavia_test.py --test_env='cheetah-vel'


# =========================
# PEARL
# =========================
# Meta-training
python launch_pearl.py --train_env='cheetah-vel'

# Adaptation after convergence
python pearl_test.py --test_env='cheetah-vel'


# =========================
# VariBAD
# =========================
# Meta-training (see original authors' repo for details)
cd varibad-master
python main.py --env-type cheetah_vel_varibad

# Adaptation after convergence
cd varibad-master
python test_varibad.py --env-type cheetah_vel_varibad


# =========================
# Meta-DT
# =========================
# Meta-training (see original authors' repo for details)
cd Meta-DT-main
# (refer to their README)

# Adaptation after convergence
python test_meta_dt.py --env-type 'cheetah_vel'


# =========================
# Behavior Cloning (BC)
# =========================
# 1) Get expert policy
python get_expert_policy.py --test_env='cheetah-vel'

# 2) Generate demonstration samples
cd reference_data
python generate_samples.py --env='cheetah-vel'
cd ..

# 3) Supervised learning (BC)
#    - train from scratch (all parameters updated)
python supervised_bc.py --test_env='cheetah-vel'
#    - use a pretrained backbone (freeze backbone; train layers only)
python supervised_bc.py --test_env='cheetah-vel' --pretrained

# 4) Evaluate
python bc_test.py --test_env='cheetah-vel'


# =========================
# Toy example
# =========================
# If you want the toy example results, run 'toy_example.ipynb'.

