# default PEARL experiment settings
# all experiments should modify these settings only as needed
default_config = dict(
    env_name='cheetah-dir',
    n_train_tasks=2,
    n_eval_tasks=2,
    latent_size=5, # dimension of the latent context vector
    net_size=300, # number of units per FC layer in each network
    env_params=dict(
        n_tasks=2, # number of distinct tasks in this domain, shoudl equal sum of train and eval tasks
        randomize_tasks=True, # shuffle the tasks after creating them
    ),
    algo_params=dict(
        meta_batch=16, # number of tasks to average the gradient across
        num_iterations=500, # number of data sampling / training iterates
        num_initial_steps=2000, # number of transitions collected per task before training
        num_tasks_sample=5, # number of randomly sampled tasks to collect data for each iteration
        num_steps_prior=400, # number of transitions to collect per task with z ~ prior
        num_steps_posterior=0, # number of transitions to collect per task with z ~ posterior
        num_extra_rl_steps_posterior=400, # number of additional transitions to collect per task with z ~ posterior that are only used to train the policy and NOT the encoder
        num_train_steps_per_itr=2000, # number of meta-gradient steps taken per iteration
        num_evals=2, # number of independent evals
        num_steps_per_eval=600,  # nuumber of transitions to eval on
        batch_size=256, # number of transitions in the RL batch
        embedding_batch_size=64, # number of transitions in the context batch
        embedding_mini_batch_size=64, # number of context transitions to backprop through (should equal the arg above except in the recurrent encoder case)
        max_path_length=200, # max path length for this environment
        discount=0.99, # RL discount factor
        soft_target_tau=0.005, # for SAC target network update
        policy_lr=3E-4,
        qf_lr=3E-4,
        vf_lr=3E-4,
        context_lr=3e-4,
        reward_scale=5., # scale rewards before constructing Bellman update, effectively controls weight on the entropy of the policy
        sparse_rewards=False, # whether to sparsify rewards as determined in env
        kl_lambda=.1, # weight on KL divergence term in encoder loss
        use_information_bottleneck=True, # False makes latent context deterministic
        use_next_obs_in_context=False, # use next obs if it is useful in distinguishing tasks
        update_post_train=1, # how often to resample the context when collecting data during training (in trajectories)
        num_exp_traj_eval=1, # how many exploration trajs to collect before beginning posterior sampling at test time
        dump_eval_paths=False, # whether to save evaluation trajectories
    ),
    sr_params=dict(
        latent_action_dim=100,
        total_step=10000000,
        eval_step=1000,
        no_sr=False
    ),
    # "reward scale 1,2,5 각각 바꿔서 해보기. 그 후에 update step 4000으로."
    meta_test_params=dict(
        method = 'esq',
        eps_clip = 0.2,
        max_grad_norm = 0.5,
        entropy_coef = 0.01,
        meta_test_discount = 0.99,
        n_epochs = 5,
        max_path_length = 200,
        reward_scale = 0.5,
        total_step=1000000,
        update_step=4000,
        no_pretrained=False,
        debug=False
    ),
    es_params=dict(
        n_rollouts = 16,
        noise_sigma = 0.05,
        lr = 0.05,
        elite_frac = 1
    ),
    es_q_params=dict(
        n_rollouts = 16,
        noise_sigma = 0.03,
        lr = 0.05,
        elite_frac = 1
    ),
    esq_params=dict(
        n_traj = 10,
        n_updates = 2000,
        exp_noise_sigma = 0.005,
        policy_lr = 0.0001,
        batch_size = 512,
        buffer_size = 200000
    ),
    util_params=dict(
        base_log_dir='output',
        use_gpu=True,
        gpu_id=0
    )
)



