from human_model import HumanModel

import yaml
import alfworld
import alfworld.agents.environment

import os 
import json 

from alfworld.agents.utils.misc import add_task_to_grammar, Demangler
import textworld

import gym 

import transformers
from transformers import AutoTokenizer, AutoModelForCausalLM, set_seed
import torch 

import numpy as np 
import argparse
import copy 

import sys 

os.environ['ALFWORLD_DATA'] = ""


def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--seed", type=int, default=0)
    parser.add_argument("--split", type=str, default="eval_out_of_distribution")
    parser.add_argument("--peftpath", type=str)
    return parser.parse_args()


def process_ob(ob):
    if ob.startswith('You arrive at loc '):
        ob = ob[ob.find('. ')+2:]
    elif ob.startswith('-= Welcome'):
        ob = '\n'.join(ob.split('\n\n')[1:])
    return ob


def get_facts_location(facts_, acutal_obj):
    facts = ""
    for f in facts_:
        if f[0] == "inreceptacle":
            facts += f[1] + " is in " + f[2] + ". "
            # facts.append(" ".join(fact))
    facts += 'You are looking for '
    oo = ', '.join(acutal_obj)+". "

    return facts + oo


def main(args):
    set_seed(args.seed)

    # === initialize the environment ===
    with open('') as reader:
        config = yaml.safe_load(reader)

    env_batch_size = 1

    split = args.split  # "train" / "eval_out_of_distribution" / "eval_in_distribution"
    print("seed:", args.seed)
    print("split:", args.split)
    if split == 'eval_out_of_distribution':
        episode_total = 134
    elif split == 'eval_in_distribution':
        episode_total = 140
    else:
        raise NotImplementedError

    # split = "eval_in_distribution"  # "train" / "eval_out_of_distribution" / "eval_in_distribution"
    alfred_env = getattr(alfworld.agents.environment, config["env"]["type"])(config, train_eval=split)
    env = alfred_env.init_env(batch_size=env_batch_size, task_type='ambiguous')


    model_path_human_model = ""
    model_path_agent_model = ""
    tokenizer_path = ""

    peft_path = args.peftpath
    print("peft:", peft_path)

    if peft_path:
        from agent_model_3 import AgentModel
    else:
        from agent_model_6 import AgentModel

    # # === initialize the human model ===
    human_model = HumanModel(model_path=model_path_human_model,
                             tokenizer_path=tokenizer_path,
                             prompt_path="")

    # # === initialize the agent ===
    agent = AgentModel(prompt_path="",
                       model_path=model_path_agent_model,
                       tokenizer_path=tokenizer_path,
                       peft_path=peft_path)


    reward_cnt_per_type = [0] * 6
    episode_cnt_per_type = [0] * 6
    ask_cnt_per_type = [0] * 6

    prefixes = {
        'pick_and_place': 0,
        'pick_clean_then_place': 1,
        'pick_heat_then_place': 2,
        'pick_cool_then_place': 3,
        'look_at_obj': 4,
        'pick_two_obj': 5
    }

    episode_reward = 0


    # === start evaluation ===
    ob, info = env.reset()
    ob = ob[0]
    pure_sa_ob = ob
    name = '/'.join(info['extra.gamefile'][0].split('/')[-3:-1])
    print(name)
    facts = get_facts_location(info['facts'][0], info['actual_obj'])

    human_model.init_prompt(facts)
    agent.init_prompt(name)

    print(ob)

    while np.sum(episode_cnt_per_type) < episode_total:

        admissible_actions = copy.deepcopy(info['admissible_commands'])
        for aa in admissible_actions:
            aa.remove('look')
            aa.remove('inventory')
            aa.append('think')
            aa.append('ask')

        action = agent.act_greedy_search(ob, pure_sa_ob, admissible_actions[0])

        observation, reward, done, info = env.step([action])

        # update human model info:
        facts = get_facts_location(info['facts'][0], info['actual_obj'])

        observation = observation[0]

        if action.startswith('ask'):
            question = action[4:]
            if not done[0]:
                observation = human_model.answer(question.strip())
            
        elif action.startswith('think'):
            if not done[0]:
                observation = 'OK.'
        
        episode_reward += reward[0]

        print(action)
        print(observation)
        sys.stdout.flush()
        
        ob += f' > {action} > {observation}'
        if not action.startswith('think'):
            pure_sa_ob += f' > {action} > {observation}'

        if done[0]:

            ob = observation
            pure_sa_ob = observation

            name = '/'.join(info['extra.gamefile'][0].split('/')[-3:-1])
            print(name)
            facts = get_facts_location(info['facts'][0], info['actual_obj'])

            for ii, (k, v) in enumerate(prefixes.items()):
                if name.startswith(k):
                    reward_cnt_per_type[ii] += episode_reward
                    episode_cnt_per_type[ii] += 1
                    ask_cnt_per_type[ii] += human_model.ask_cnt
            
            episode_reward = 0
        
            print("perR:", reward_cnt_per_type, "\tperE:", episode_cnt_per_type, "\tperAsk:", ask_cnt_per_type,
                  "\tperAvgR:", np.array(reward_cnt_per_type) / np.array(episode_cnt_per_type),
                  "\tAvgR:", np.sum(reward_cnt_per_type) / np.sum(episode_cnt_per_type), "\tSumE:", np.sum(episode_cnt_per_type))

            human_model.init_prompt(facts)
            agent.init_prompt(name)



if __name__ == '__main__':
    args = get_args()
    main(args)