import sys
import os
curPath = os.path.abspath(os.path.dirname(__file__))
rootPath = os.path.split(curPath)[0]
sys.path.append(rootPath)

from build_envs import locomotion_gym_env
from build_envs import locomotion_gym_config
from build_envs.env_wrappers import observation_dictionary_to_array_wrapper
from build_envs.env_wrappers import trajectory_generator_wrapper_env
from build_envs.env_wrappers import simple_openloop
# from build_envs.tasks import running_task
from build_envs.tasks import terrains_task
from build_envs.sensors import environment_sensors
from build_envs.sensors import sensor_wrappers
from build_envs.sensors import robot_sensors
from build_envs.utilities import controllable_env_randomizer_from_config
from robots import a1


def build_terrains_env(enable_randomizer, enable_rendering,RECORD_VIDEO,max_step_num,env_id=None):

    sim_params = locomotion_gym_config.SimulationParameters()
    sim_params.enable_rendering = enable_rendering

    gym_config = locomotion_gym_config.LocomotionGymConfig(simulation_parameters=sim_params)

    robot_class = a1.A1

    sensors = [
        # sensor_wrappers.HistoricSensorWrapper(
        #     wrapped_sensor=robot_sensors.MotorAngleSensor(num_motors=a1.NUM_MOTORS), num_history=3),
        # sensor_wrappers.HistoricSensorWrapper(wrapped_sensor=robot_sensors.IMUSensor(), num_history=3),
        # sensor_wrappers.HistoricSensorWrapper(
        #     wrapped_sensor=environment_sensors.LastActionSensor(num_actions=a1.NUM_MOTORS), num_history=3)

        sensor_wrappers.HistoricSensorWrapper(
             wrapped_sensor=robot_sensors.DesiredDirection(), num_history=1),
        # sensor_wrappers.HistoricSensorWrapper(
        #     wrapped_sensor=robot_sensors.DesiredTurningDirection(), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.IMUSensor(), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.BaseAngularVelocitySensor(), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.BaseLinearVelocitySensor(), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.JointPositionSensor(num_motors=a1.NUM_MOTORS), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.JointVelocitySensor(num_motors=a1.NUM_MOTORS), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.FTGPhasesSensor(), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.FTGFrequenciesSensor(), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.BaseFrequencySensor(), num_history=1),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.JointPositionErrorHistorySensor(num_motors=a1.NUM_MOTORS), num_history=2),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.JointVelocityHistorySensor(num_motors=a1.NUM_MOTORS), num_history=2),
        sensor_wrappers.HistoricSensorWrapper(
            wrapped_sensor=robot_sensors.FootTargetHistorySensor(num_motors=a1.NUM_MOTORS), num_history=2),

        # sensor_wrappers.HistoricSensorWrapper(
        #     wrapped_sensor=robot_sensors.QdotTargetHistorySensor(num_motors=a1.NUM_MOTORS), num_history=2),
        # sensor_wrappers.HistoricSensorWrapper(
        #     wrapped_sensor=robot_sensors.TorqueTargetHistorySensor(num_motors=a1.NUM_MOTORS), num_history=2),

        # sensor_wrappers.HistoricSensorWrapper(
        #     wrapped_sensor=robot_sensors.HeightSensor(), num_history=1),
        # sensor_wrappers.HistoricSensorWrapper(
        #     wrapped_sensor=robot_sensors.PrivilegedInformationSensor(), num_history=1)
    ]

    task = terrains_task.TerrainsTask()

    randomizers = []
    if enable_randomizer:
        randomizer = controllable_env_randomizer_from_config.ControllableEnvRandomizerFromConfig(verbose=False)
        randomizers.append(randomizer)

    env = locomotion_gym_env.LocomotionGymEnv(gym_config=gym_config, robot_class=robot_class,
                                              env_randomizers=randomizers, robot_sensors=sensors, task=task,
                                              RECORD_VIDEO=RECORD_VIDEO,
                                              max_step_num=max_step_num,
                                              env_id=env_id
                                              )

    env = observation_dictionary_to_array_wrapper.ObservationDictionaryToArrayWrapper(env)


    return env
