#!/bin/bash
# python PATH
# export PYTHONPATH="${PYTHONPATH}:${HOME}/github"

# hyperparameter
echo -n "input the gpu (seperate by comma (,) ): "
read gpus
export CUDA_VISIBLE_DEVICES=${gpus}
echo "using gpus ${gpus}"

# choose the method
echo "balanced -- full OT"
echo "unbalanced -- unbalanced OT"
echo "partial -- partial OT"
echo -n "choose the loss_type: "
read ot_type
if [ $ot_type = 'partial' ]
then
    loss_type=POT
elif [ $ot_type = 'unbalanced' ]
then
    loss_type=UOT
else
    loss_type=OT
fi

echo ""
echo "0 -- default"
echo -n "run_id: "
read run_id

# OT parameters
BATCH=72
if [ $ot_type = 'unbalanced' ]
then
    EPSILON=0.01
else
    EPSILON=0
fi

for num in 01
do
    case ${num} in
        01 )
            s_dset_path="./data/visda-2017/train_list.txt"
            t_dset_path="./data/visda-2017/validation_list.txt"
            output_dir="train_val"
            ;;
    esac

    DES="home_${output_dir}_${loss_type}_run${run_id}"
    final_log="home_${loss_type}_run${run_id}"

    # eval checkpoint
    for i in {10..10}
    do
        MASS=$(echo "scale=2; $i / 20" | bc -l)
        echo "-- mass = $MASS"
        output_dir="${DES}_mass0${MASS}_m${BATCH}_epsilon${EPSILON}"
        echo "Begin in eval_${output_dir}"
        echo "log in ${final_log}.txt"
        python evaluate.py --gpu_id ${gpus} \
                        --net ResNet50 \
                        --dset visda \
                        --s_dset_path ${s_dset_path} \
                        --t_dset_path ${t_dset_path} \
                        --batch_size $BATCH \
                        --output_dir eval_${output_dir} \
                        --final_log "${final_log}.txt" \
                        --restore_dir ${output_dir}
        echo "Finish in ${output_dir}"
    done
done

echo "Training Finished!!!"