#!/bin/bash
# hyperparameter
echo -n "input the gpu (seperate by comma (,) ): "
read gpus
export CUDA_VISIBLE_DEVICES=${gpus}
echo "using gpus ${gpus}"

# choose the method
echo ""
echo "0  --  JDOT"
echo "1  --  JUMBOT"
echo "2  --  JPMBOT"
echo -n "choose the method: "
read method_choose

case ${method_choose} in
    0 )
        METHOD="jdot"
        ;;
    1 )
        METHOD="jumbot"
        ;;
    2 )
        METHOD="jpmbot"
        ;;
    * )
        echo "The choice of method is illegal!"
        exit 1 
        ;;
esac

SOURCE=usps
TARGET=mnist
DATA_DIR=./data
K=1
BATCH_SIZE=500
EPOCH=100
TEST_INTERVAL=1
CLASS=10
if [ $METHOD = 'jumbot' ]
then
    EPSILON=0.01
else
    EPSILON=0
fi
TAU=1.
MASS=0.9
ETA1=0.1
ETA2=0.1
for LR in 2e-4 3e-4 4e-4
do
    python train_digits.py --gpu_id ${gpus} --method $METHOD --source_ds $SOURCE --target_ds $TARGET --data_dir $DATA_DIR --k $K --mbsize $BATCH_SIZE --n_epochs $EPOCH --test_interval $TEST_INTERVAL --nclass $CLASS --epsilon $EPSILON --tau $TAU --mass $MASS --lr $LR --eta1 $ETA1 --eta2 $ETA2
done