#!/bin/bash
# choose GPU
echo -n "Input the GPU id: "
read GPU
export CUDA_VISIBLE_DEVICES=${GPU}
echo "using gpus ${GPU}"

echo -n "Input dataset (cifar|celeba): "
read DATASET

# choose the method
METHOD=POT # OT, UOT, POT

# choose the regularization coefficient
if [ $METHOD = 'UOT' ]
then
    REG=1
else
    REG=0
fi

# choose number of minibatches
K=2
BATCH=200
LATENT_DIM=32
TAU=1
EPOCH=1
LR=5e-4
DATADIR=.data/

for i in {10..10}
do
    MASS=$(echo "scale=2; $i / 20" | bc -l)
    echo "-- mass = $MASS"
    python main_${DATASET}.py --method $METHOD --reg $REG --tau $TAU --mass $MASS --k $K --epochs $EPOCH --gpu-id $GPU --m $BATCH --lr $LR --latent-size $LATENT_DIM --datadir $DATADIR
done