This folder contains all scripts and a dockerfile to reproduce our experiments.

Note that, contents in [scripts/SGT_PG/](scripts/SGT_PG/) are modified contents in https://github.com/tomjur/SGT-PG.

# Building an environment

You can use [Dockerfile](Dockerfile) to build an environment.

# Experiments

You can use a script [scripts/run.sh](scripts/run.sh) to run all experiments.

The IDs of used GPU can be specified by editting this script.

The results are stored in `exp` folder.

```
mkdir exp
cd scripts
bash run.sh
cd ..
```

# Viewing Results

After all experiments are done, results can be plotted by a script [scripts/show_graph.py](scripts/show_graph.py).

Examples of generated paths can be visualized by a script [scripts/view_trajs.py](scripts/view_trajs.py).

The images are stored in `figures` folder.

Examples of motions of Panda can be visualized by a script [scripts/visualize_panda.py](scripts/visualize_panda.py), which outputs images in `panda_figures` folder.

```
mkdir figures
cd scripts
python3 show_graph.py
python3 view_trajs.py
mkdir ../panda_figures
python3 visualize_panda.py
cd ..
```
